/*
 * Created on 2005/10/15
 *
 * Copyright (C) 2005- Monami software, LP.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Monami software, LP. - Initial API and implementation
 */
package jp.pizzafactory.crosschains;

import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.osgi.framework.Bundle;

public class PizzaBin implements IBuildMacro {

	public static final String NAME = "pizzaBin"; //$NON-NLS-1$//
	public final PizzaBinPath pizzaBinPath;
	public final Bundle bundle;

	public PizzaBin(Bundle bundle) {
		pizzaBinPath = new PizzaBinPath();
		this.bundle = bundle;
	}
	public String getName() {
		// TODO Auto-generated method stub
		return NAME;
	}

	public int getMacroValueType() {
		// TODO Auto-generated method stub
		return IBuildMacro.VALUE_PATH_DIR;
	}

	public String getStringValue() throws BuildMacroException {
		return pizzaBinPath.getValue(bundle);
	}

	public String[] getStringListValue() throws BuildMacroException {
		String[] result = new String[1];
		result[0] = getStringValue();
		return result;
	}
}
