/*
 * Created on 2006/08/18
 *
 * Copyright (C) 2005- Monami software, LP.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Monami software, LP. - Initial API and implementation
 */
package jp.pizzafactory.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PathConverter {

	private static final String id = "jp.pizzafactory.core.pathConverter"; //$NON-NLS-1$

	public static String asShort(Bundle bundle, String pathName) {
		IPathConverter pathConverter = getPathConverter();
		if (pathConverter == null) {
			return null;
		}
		return pathConverter.asShort(bundle, pathName);
	}

	public static String asShort(String pathName) {
		IPathConverter pathConverter = getPathConverter();
		if (pathConverter == null) {
			return null;
		}
		return pathConverter.asShort(pathName);
	}

	private static IPathConverter getPathConverter() {
		IExtensionRegistry extensionReg = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint = extensionReg.getExtensionPoint(id);
		IExtension[] extensions = extensionPoint.getExtensions();
		for (int i = 0; i < extensions.length; i++) {
			IConfigurationElement[] elements =  extensions[i].getConfigurationElements();
			for (int j = 0; j < elements.length; j++) {
				Object o;
				try {
					o = elements[j].createExecutableExtension("class"); //$NON-NLS-1$
					if (o instanceof IPathConverter) {
							return (IPathConverter)o;
					}
				} catch (CoreException e) {
					// nothing special to do.
				}
			}
		}

		return null;
	}
}
