'\"
'\" Copyright (c) 1997 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) calendar.n 1.0 97/04/30 16:04:44
'/" 
.so man.macros
.HS calendar iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
calendar \- Create and manipulate a monthly calendar
.SH SYNOPSIS
\fBcalendar\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- calendar
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBcursor\fR	\fBforeground\fR	
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBbackwardImage\fR
Class:	\fBImage\fR
Command-Line Switch:	\fB-backwardimage\fR
.fi
.IP
Specifies a image to be displayed on the backwards calendar 
button.  This image must have been created previously with 
the \fBimage create\fR command.  If none is specified, a default 
is provided.
.LP
.nf
Name:	\fBbuttonForeground\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB-buttonforeground\fR
.fi
.IP
Specifies the foreground color of the forward and backward buttons
in any of the forms acceptable to \fBTk_GetColor\fR.  The default
color is blue.
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-command\fR
.fi
.IP
Specifies a Tcl script to executed upon selection of a date in the
calendar.  If the command script contains any \fB%\fR characters, 
then the script will not be executed directly.  Instead, a new 
script will be generated by replacing each \fB%\fR, and the 
character following it, with information from the calendar.  The 
replacement depends on the character following the \fB%\fR, as 
defined in the list below.
.TP
\fB%d\fR
Replaced with the date selected in the format mm/dd/yyyy.
.LP
.nf
Name:	\fBcurrentDateFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-currentdatefont\fR
.fi
.IP
Specifies the font used for the current date text in any of the forms
acceptable to \fBTk_GetFont\fR.
.LP
.nf
Name:	\fBdateFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-datefont\fR
.fi
.IP
Specifies the font used for the days of the month text in any of the forms
acceptable to \fBTk_GetFont\fR.
.LP
.nf
Name:	\fBdayFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-dayfont\fR
.fi
.IP
Specifies the font used for the days of the week text in any of the forms
acceptable to \fBTk_GetFont\fR.
.LP
.nf
Name:	\fBdays\fR
Class:	\fBdays\fR
Command-Line Switch:	\fB-days\fR
.fi
.IP
Specifies a list of values to be used for the days of the week
text to displayed above the days of the month.  The default value 
is {Su Mo Tu We Th Fr Sa}.
.LP
.nf
Name:	\fBforewardImage\fR
Class:	\fBImage\fR
Command-Line Switch:	\fB-forewardimage\fR
.fi
.IP
Specifies a image to be displayed on the forewards calendar 
button.  This image must have been created previously with 
the \fBimage create\fR command.  If none is specified, a default 
is provided.
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB-height\fR
.fi
.IP
Specifies a desired window height that the calendar widget should 
request from its geometry manager.  The value may be specified in any  
of the forms acceptable to \fBTk_GetPixels\fR.  The default height
is 165 pixels.
.LP
.nf
Name:	\fBoutline\fR
Class:	\fBOutline\fR
Command-Line Switch:	\fB-outline\fR
.fi
.IP
Specifies the outline color used to surround the days of the month text in
any of the forms acceptable to \fBTk_GetColor\fR.  The default is the
same color as the background.
.LP
.nf
Name:	\fBselectColor\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB-selectcolor\fR
.fi
.IP
Specifies the color of the ring displayed that distinguishes the 
currently selected date in any of the forms acceptable to 
\fBTk_GetColor\fR.  The default is red.
.LP
.nf
Name:	\fBselectThickness\fR
Class:	\fBSelectThickness\fR
Command-Line Switch:	\fB-selectthickness\fR
.fi
.IP
Specifies the thickness of the ring displayed that distinguishes 
the currently selected date.  The default is 3 pixels.
.LP
.nf
Name:	\fBstartday\fR
Class:	\fBDay\fR
Command-Line Switch:	\fB-startday\fR
.fi
.IP
Specifies the starting day for the week: \fBsunday\fR, \fBmonday\fR, 
\fBtuesday\fR, \fBwednesday\fR, \fBthursday\fR, \fBfriday\fR, or
\fBsaturday\fR.  The default is sunday.
.LP
.nf
Name:	\fBtitleFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-titlefont\fR
.fi
.IP
Specifies the font used for the title text which consists of the
month and year.  The font may be given in any of the forms
acceptable to \fBTk_GetFont\fR.
.LP
.nf
Name:	\fBweekdayBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-weekdaybackground\fR
.fi
.IP
Specifies the background color for the weekdays which allows it to
be visually distinguished from the weekend.  The color may be given
in any of the forms acceptable to \fBTk_GetColor\fR.  The default is
the same as the background.
.LP
.nf
Name:	\fBweekendBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-weekendbackground\fR
.fi
.IP
Specifies the background color for the weekends which allows it to
be visually distinguished from the weekdays.  The color may be given
in any of the forms acceptable to \fBTk_GetColor\fR.  The default is
the same as the background.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-width\fR
.fi
.IP
Specifies a desired window width that the calendar widget should 
request from its geometry manager.  The value may be specified in any  
of the forms acceptable to \fBTk_GetPixels\fR.  The default width
is 200 pixels.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBcalendar\fR command creates a calendar widget for the selection 
of a date, displaying a single month at a time.  Buttons exist on the 
top to change the month in effect turning the pages of a calendar.  As 
a page is turned, the dates for the month are modified.  Selection of 
a date visually marks that date.  The selected value can be monitored 
via the -command option or just retrieved using the get command.  

.SH "METHODS"
.PP
The \fBcalendar\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for calendar widgets:

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBcalendar\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBcalendar\fR
command.
.TP
\fIpathName \fBget\fR ?\fBformat\fR?
Returns the currently selected date in a format of 
string or as an integer clock value using the \fB-string\fR and \fB-clicks\fR
format options respectively.  The default is by string.  Reference the 
clock command for more information on obtaining dates and their 
formats.
.TP
\fIpathName \fBselect\fR \fIdate\fR
Changes the currently selected date to the value specified which 
must be in the form of a date string, an integer clock value or as
the keyword "now".  Reference the clock 
command for more information on obtaining dates and their formats.
Note that selecting a date does not change the 
month being shown to that of the date given.  This chore is left
to the \fBshow\R command.
.TP
\fIpathName \fBshow\fR \fIdate\fR
Changes the currently displayed date to be that of the date 
argument which must be in the form of a date string, an 
integer clock value or as
the keyword "now".  Reference the clock 
command for more information on obtaining dates and their formats.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBforward\fR
Class:	\fBButton\fR
.fi
.IP
The forward component provides the button on the upper right of the
calendar that changes the month to be the next.  See the "button" 
widget manual entry for details on the forward component item.
.LP
.nf
Name:	\fBpage\fR
Class:	\fBCanvas\fR
.fi
.IP
The page component provides the canvas on which the title, days of the
week, and days of the month appear.  See the "canvas" widget manual 
entry for details on the page component item.
.LP
.nf
Name:	\fBbackward\fR
Class:	\fBButton\fR
.fi
.IP
The backward component provides the button on the upper right of the
calendar that changes the month to be the next.  See the "button" 
widget manual entry for details on the backward component item.

.SH EXAMPLE
.DS
 proc selectCmd {date} {
   puts $date
 }

 calendar .c -command {selectCmd %d} -weekendbackground mistyrose \\
	-weekdaybackground ghostwhite -outline black \\
        -startday wednesday -days {We Th Fr Sa Su Mo Tu}
 pack .c 
.DE
.SH AUTHOR
Mark L. Ulferts
.DE
Michael J. McLennan
.SH KEYWORDS
calendar, widget
