﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace Lugens.Components
{
    public partial class KeycodeTextBox : TextBox
    {
        //static Dictionary<int, string> keyDic = null;

        protected List<int> acceptKeys = null;
        public List<int> AcceptKeys
        {
            get
            {
                return this.acceptKeys;
            }

            set
            {
                this.acceptKeys = value;
            }
        }

        protected char keycode = (char)0;
        public char Keycode
        {
            get
            {
                return keycode;
            }
            set
            {
                this.keycode = value;
                this.Text = ((Keycode)value).ToString();
            }
        }

        public KeycodeTextBox()
        {
            InitializeComponent();
            this.ImeMode = ImeMode.Disable;
            this.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.TabStop = false;
            this.ContextMenu = new ContextMenu();
        }

        protected override void OnKeyPress(KeyPressEventArgs e)
        {
            e.Handled = true;
        }

        protected override void OnKeyDown(KeyEventArgs e)
        {
            e.Handled = true;
        }

        protected override void OnTextChanged(EventArgs e)
        {
            base.OnTextChanged(e);
            this.SelectionStart = this.Text.Length;
        }

        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
                case 0x0100: //WM_KEYDOWN
                case 0x0101: //WM_KEYUP
                case 0x0104: //WM_SYSKEYDOWN
                case 0x0105: //WM_SYSKEYUP
                    if (this.acceptKeys == null || !this.acceptKeys.Contains((int)m.WParam))
                    {
                        this.keycode = (char)0;
                        this.Text = "Not Use";
                        break;
                    }

                    switch ((int)m.WParam)
                    {
                        case 0x10: //Shiftキー
                            switch ((int)m.LParam)
                            {
                                case 0x2A0001:
                                    this.keycode = (char)160;
                                    //this.Text = "Press(LShift)";
                                    break;
                                case 0x360001:
                                    this.keycode = (char)161;
                                    //this.Text = "Press(RShift)";
                                    break;
                            }
                            break;
                        case 0x11: //Controlキー
                            switch ((int)m.LParam)
                            {
                                case 0x1D0001:
                                    this.keycode = (char)162;
                                    //this.Text = "Press(LControl)";
                                    break;
                                case 0x11D0001:
                                    this.keycode = (char)163;
                                    //this.Text = "Press(RControl)";
                                    break;
                            }
                            break;
                        case 0x12: //Altキー
                            switch ((int)m.LParam)
                            {
                                case 0x20380001:
                                    this.keycode = (char)164;
                                    //this.Text = "Press(LAlt)";
                                    break;
                                case 0x21380001:
                                    this.keycode = (char)165;
                                    //this.Text = "Press(RAlt)";
                                    break;
                            }
                            break;
                        default:
                            this.keycode = (char)m.WParam;
                            //this.Text = "Press(" + (int)m.WParam + ")";
                            break;
                    }
                    this.Text = ((Keycode)this.keycode).ToString();
                    //this.Text = ((Keys)this.keycode).ToString();
                    break;
                case 0x204: //WM_RBUTTONDOWN
                    return;
            }
            base.WndProc(ref m);
        }
    
    }
}
