
/* --------------------------------------------- */
/*  H8-3069F USB Mass Storage Class              */
/*                                               */
/*  CPU    : Renesus H8/3069F 25MHz              */
/*  Memory : ROM 512KB, RAM 16KB E-RAM 2MB       */
/*                (c) KAZ.Imamura                */
/* --------------------------------------------- */

#ifndef __USBMS_H__
#define __USBMS_H__

#include "common.h"
#include "sl811.h"

typedef struct {
	unsigned long	logical_block_address;
	unsigned int	transfer_length;
	unsigned char*	p_buffer;
} READ10_REQ, *P_READ10_REQ;

extern void usbms_1ms_handler(void);
extern int  usbms_initialize(void);
extern int  usbms_process(void);
extern int ui_function_usbms_debug(UI_COMMAND uicmd);
extern unsigned char usbms_status(unsigned char req);
extern unsigned char usbms_read10(P_READ10_REQ p_req);

#endif

