<?php
// {{{ GLOBALS

$GLOBALS['_SESS_VERSION'] = 1; // ZbṼo[WiSẲғrZbVjUP肷j

// }}}
// {{{ Session

/**
 * Session Class
 *
 * IR, UA, ANZXԂ̃`FbN𔺂AZLAȃZbVǗNX
 * قƂǎœ̂ł܂CɂAʏʂ $_SESSION ̒l舵΂悢B
 * A$_SESSION[$this->sess_array]i$_SESSION['_sess_array']j ͗\ƂȂĂB
 *
 * p
 * $_session = new Session(); // ̎_PHPWZbVX^[g
 * if ($msg = $_session->checkSessionError()) { // ZLAȃZbV`FbN
 *     p2die($msg);
 * }
 *
 * $_SESSIONւ̃ANZXÍAsession_write_close()ĂƂ悢낤B
 *
 * dv
 * php.ini  session.auto_start = 0 (PHP̃ftHĝ܂) ɂȂĂ邱ƁB
 * ȂƂقƂǂ̃ZbV֘Ãp[^XNvgŕύXłȂB
 * .htaccessŕύXĂȂ
 *
 * <IfModule mod_php4.c>
 *    php_flag session.auto_start Off
 * </IfModule>
 *
 * łOKB
 *
 * @author aki
 */
class Session
{
    // {{{ static properties

    static public $_session_started = false;

    // }}}
    // {{{ properties

    public $sess_array = '_sess_array';

    // }}}
    // {{{ constructor

    /**
     * RXgN^
     *
     * PHP̕WZbVX^[g
     */
    public function __construct($session_name = null, $session_id = null)
    {
        $this->setCookieHttpOnly();

        // LbVȂ
        session_cache_limiter('none');

        // ZbVуZbVIDݒ
        if ($session_name) {
            session_name($session_name);
        }
        if ($session_id) {
            session_id($session_id);
        }

        // ZbVf[^
        session_start();
        self::$_session_started = true;

        /*
        Expires: Thu, 19 Nov 1981 08:52:00 GMT
        Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0
        Pragma: no-cache
        */
    }

    // }}}
    // {{{ _autoBegin()

    /**
     * ZLAȃZbVǗJn
     * @return bool
     */
    private function _autoBegin()
    {
        // ܂ZbVn܂ĂȂ
        if (!isset($_SESSION[$this->sess_array]['actime'])) {

            // ZbVϐ($this->sess_array)Zbg
            $this->_initSess();

            // ZbVϐ̓o^ɎsAG[
            if (!isset($_SESSION[$this->sess_array]['actime'])) {
                trigger_error('Session::_autoBegin() ZbVϐo^ł܂łB', E_USER_WARNING);
                p2die('Session');
                return false;
            }
        }

        return true;
    }

    // }}}
    // {{{ _initSess()

    /**
     * ZbVn߂ɕϐZbg
     *
     * @return void
     */
    private function _initSess()
    {
        // 
        $_SESSION[$this->sess_array] = array();

        $_SESSION[$this->sess_array]['actime']     = time();
        $_SESSION[$this->sess_array]['ip']         = $_SERVER['REMOTE_ADDR'];
        $_SESSION[$this->sess_array]['ua']         = $_SERVER['HTTP_USER_AGENT'];
        // $_SESSION[$this->sess_array]['referer'] = $_SERVER['HTTP_REFERER'];
        $_SESSION[$this->sess_array]['version']    = $GLOBALS['_SESS_VERSION'];
    }

    // }}}
    // {{{ checkSessionError()

    /**
     * ZbV̑Ó`FbNāAG[΃bZ[W𓾂BANZXԂ̍XVŁB
     *
     * @return false|string G[΁AiunSession()ājG[bZ[WԂBȂfalseԂB
     */
    public function checkSessionError()
    {
        // ZbV
        $this->_autoBegin();

        $error_msg = '';

        if (!isset($_SESSION[$this->sess_array]['actime'])) {
            $error_msg = 'ZbV@\Ă܂B';

        } else {

            if (!$this->_checkAcTime()) {
                $error_msg = 'ZbV̎Ԑ؂łBēxOCĂB';
            }

            if (!$this->_checkVersion()) {
                $error_msg = 'ZbṼo[W܂B'
                    .'i̓VXẽo[WAbvɂāAꎞIɋN邱Ƃ̂錻ۂłj';
            }

            if (!$this->_checkIP()) {
                $error_msg = 'ZbVIP܂B';
            }

            if (!$this->_checkUA()) {
                $error_msg = 'ZbVUA܂B';
            }
        }

        // G[΁AiunSession()ājG[bZ[WԂB
        if ($error_msg) {
            self::unSession();
            return $error_msg;
        }

        // Ȃ΁AANZXԂXV
        $_SESSION[$this->sess_array]['actime'] = time();

        // NG[SIDtꍇ́A session_regenerate_id() AAƏs
        // ߋANZX5ȑO𖳌ɂƂłA
        /*
        $sname = session_name();
        if (!$_COOKIE[$sname]) {
            $oldID = session_id();
            session_regenerate_id();
            unlink(session_save_path() . "/sess_$oldID");
        }
        */

        return false;
    }

    // }}}
    // {{{ _checkAcTime()

    /**
     * ZbṼANZXԂ`FbN
     *
     * @return bool
     */
    private function _checkAcTime($minutes = 30)
    {
        // ŏIANZXԂA莞Ԉȏオo߂ĂExpire
        if ($_SESSION[$this->sess_array]['actime'] + $minutes * 60 < time()) {
            return false;
        } else {
            return true;
        }
    }

    // }}}
    // {{{ _checkVersion()

    /**
     * ZbṼo[W`FbN
     *
     * @return bool
     */
    private function _checkVersion()
    {
        if ($_SESSION[$this->sess_array]['version'] == $GLOBALS['_SESS_VERSION']) {
            return true;
        } else {
            return false;
        }
    }

    // }}}
    // {{{ _checkIP()

    /**
     * IPAhXÓ`FbN
     *
     * @return bool
     */
    private function _checkIP()
    {
        $check_level = 1; // 0`4 docomolƁA1܂

        $ses_ips = explode('.', $_SESSION[$this->sess_array]['ip']);
        $now_ips = explode('.', $_SERVER['REMOTE_ADDR']);

        for ($i = 0; $i++; $i < $check_level) {
            if ($ses_ips[$i] != $now_ips[$i]) {
                return false;
            }
        }
        return true;
    }

    // }}}
    // {{{ _checkUA()

    /**
     * UAŃZbV̑Ó`FbN
     *
     * @return bool
     */
    private function _checkUA()
    {
        // {{{ docomoUTNUA㕔ς̂ŋ@햼Ō؂

        $mobile = Net_UserAgent_Mobile::singleton();
        if ($mobile->isDoCoMo()) {
            $mobile_b = Net_UserAgent_Mobile::factory($_SESSION[$this->sess_array]['ua']);
            if ($mobile_b->getModel() == $mobile->getModel()) {
                return true;
            }
        }

        // }}}

        // $offset = 12;
        if (empty($offset)) {
            $offset = strlen($_SERVER['HTTP_USER_AGENT']);
        }
        if (substr($_SERVER['HTTP_USER_AGENT'], 0, $offset) == substr($_SESSION[$this->sess_array]['ua'], 0, $offset)) {
            return true;
        } else {
            return false;
        }
    }

    // }}}
    // {{{ unSession()

    /**
     * $_SESSIONŃZbVj
     *
     * ZbVȂA͐ȂꍇȂǂ
     * http://jp.php.net/manual/ja/function.session-destroy.php
     *
     * @return void
     */
    static public function unSession()
    {
        global $_conf;

        // ZbV̏
        // session_name("something")gpĂꍇ͓ɂYȂ悤!
        if (!self::$_session_started) {
            session_start();
        }

        // ZbVϐSĉ
        $_SESSION = array();

        // ZbVؒfɂ̓ZbVNbL[폜B
        $session_name = session_name();
        if (isset($_COOKIE[$session_name])) {
           //setcookie($session_name, '', time() - 42000);
           P2Util::unsetCookie($session_name);
           unset($_COOKIE[$session_name]);
        }

        // ŏIIɁAZbVj󂷂
        if (isset($_conf['session_dir'])) {
            $session_file = $_conf['session_dir'] . '/sess_' . session_id();

        } else {
            $session_file = session_save_path() . '/sess_' . session_id();
        }

        session_destroy();
        if (file_exists($session_file)) {
            unlink($session_file);
        }
    }

    // }}}
    // {{{ setCookieHttpOnly()

    /**
     * ZbVsetcookieHttpOnlyw肷
     * http://msdn2.microsoft.com/ja-jp/library/system.web.httpcookie.httponly(VS.80).aspx
     *
     * @param   void
     * @return  void
     */
    private function setCookieHttpOnly()
    {
        $ua = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : null;

        // Mac IÉAsǂN炵ۂ̂őΏۂOBiΉĂȂj
        // Mozilla/4.0 (compatible; MSIE 5.16; Mac_PowerPC)
        if (preg_match('/MSIE \d\\.\d+; Mac/', $ua)) {
            return;
        }

        ini_set('session.cookie_httponly', true);
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
