<?php
/* vim: set fileencoding=cp932 ai et ts=4 sw=4 sts=0 fdm=marker: */
/* mi: charset=Shift_JIS */

// {{{ class GoogleSearch

/**
 * GoogleNX𐶐NX
 *
 * t@Ngp^[gĂ݂B
 */
class GoogleSearch
{
    // {{{ factory()

    /**
     * PHP̃o[WɉSOAPNCAg@\𗘗pNXI
     *
     * @param string $wsdl  Google Search WSDLt@C̃pX
     * @param string $key   Google Key
     * @return object
     * @access public
     */
    function &factory($wsdl, $key)
    {
        if (substr(phpversion(), 0, 1) == '5') {
            require_once dirname(__FILE__) . '/search_php5.class.php';
            $google = &new GoogleSearch_PHP5();
        } else {
            require_once dirname(__FILE__) . '/search_php4.class.php';
            $google = &new GoogleSearch_PHP4();
        }
        $available = $google->init($wsdl, $key);
        if (PEAR::isError($available)) {
            return $available;
        }
        return $google;
    }

    // }}}
}

// }}}
// {{{ class GoogleSearch_Common

/**
 * Google Web APIs 𗘗pČNX
 *
 * SOAP̎gPHP4PHP5őSقȂ̂ŁA
 * ̃NXpĂꂼɑΉNXB
 */
class GoogleSearch_Common
{
    // {{{ properties

    /**
     * Google Search WSDLt@C̃pX
     *
     * @var string
     * @access protected
     */
    var $wsdl;

    /**
     * Google Web APIs ̃CZXL[
     *
     * @var string
     * @access protected
     */
    var $key;

    /**
     * ۂGoogleNX̃CX^X
     *
     * @var object
     * @access protected
     */
    var $soapClient;

    // }}}
    // {{{ constructor

    /**
     * RXgN^
     *
     * @return void
     * @access public
     */
    function GoogleSearch()
    {
    }

    // }}}
    // {{{ setConf

    /**
     * ݒ̏
     *
     * @param string $wsdl  Google Search WSDLt@C̃pX
     * @param string $key   Google Web APIs ̃CZXL[
     * @return void
     * @access public
     */
    function setConf($wsdl, $key)
    {
        $this->wsdl = $wsdl;
        $this->key  = $key;
    }

    // }}}
    // {{{ prepareParams()

    /**
     * GoogleɑMl
     *
     * @param string  $q  L[[h
     * @param integer $start  ʂ擾ʒu
     * @param integer $maxResults  ʂ擾ő吔
     * @return array
     * @access public
     */
    function prepareParams($q, $maxResults = 10, $start = 0)
    {
        // p[^
        // <!-- note, ie and oe are ignored by server; all traffic is UTF-8. -->
        // <message name="doGoogleSearch">
        return array(
            'key'   => $this->key,  // <part name="key"        type="xsd:string"/>
            'q'     => $q,          // <part name="q"          type="xsd:string"/>
            'start' => $start,      // <part name="start"      type="xsd:int"/>
            'maxResults' => $maxResults, // <part name="maxResults" type="xsd:int"/>
            'filter'    => FALSE,   // <part name="filter"     type="xsd:boolean"/>
            'restrict' => '',       // <part name="restrict"   type="xsd:string"/>
            'safeSearch' => FALSE,  // <part name="safeSearch" type="xsd:boolean"/>
            'lr' => '',             // <part name="lr"         type="xsd:string"/>
            'ie' => 'utf-8',        // <part name="ie"         type="xsd:string"/>
            'oe' => 'utf-8'         // <part name="oe"         type="xsd:string"/>
        );
        // </message>
    }

    // }}}
    // {{{ init()

    /**
     * SOAPNCAg̃CX^X𐶐
     *
     * ̃NXł̓C^[tF[X̒񋟂̂
     *
     * @param string $wsdl  Google Search WSDLt@C̃pX
     * @param string $key   Google Web APIs ̃CZXL[
     * @return boolean
     * @access public
     */
    function init($wsdl, $key)
    {
        return PEAR::raiseError('class GoogleSearch_Common must be inherited.');
    }

    // }}}
    // {{{ doSearch()

    /**
     * s
     *
     * ̃NXł̓C^[tF[X̒񋟂̂
     *
     * @param string  $q  L[[h
     * @param integer $start  ʂ擾ʒu
     * @param integer $maxResults  ʂ擾ő吔
     * @return object
     * @access public
     */
    function doSearch($q, $maxResults, $start)
    {
        return PEAR::raiseError('class GoogleSearch_Common must be inherited.');
    }

    // }}}
}

// }}}

?>
