/**
 * ImageCache2::FitImage
 */

// {{{ GLOBALS

var fiTimer = null;

// }}}
// {{{ FitImage IuWFNg

/*
 * RXgN^
 *
 * @param String id	 摜id܂DOMvf
 * @param Number width  摜̕
 * @param Number height 摜̍
 */
function FitImage(id, width, height)
{
	this.picture = (typeof id == 'string') ? document.getElementById(id) : id;
	this.imgX = width;
	this.imgY = height;
	this.ratio = width / height;
	this.currentMode = 'init';
	this.defaultMode = (getWindowWidth() > width && getWindowHeight() > height) ? 'expand' : 'contract';
}

// }}}
// {{{ FitImage.fitTo()

/*
 * 摜EChEɃtBbg
 *
 * @param String mode
 * @return void
 */
FitImage.prototype.fitTo = function(mode)
{
	if (this.currentMode == mode || (this.currentMode == 'init' && this.defaultMode == 'expand')) {
		// ̑傫ɖ߂
		this.currentMode = 'auto';
		this.picture.style.width = 'auto';
		this.picture.style.height = 'auto';
	} else {
		var winX, winY, cssX, cssY;

		winX = getWindowWidth();
		winY = getWindowHeight();

		// EChEɍ킹ĊgEk
		switch (mode) {
		  case 'contract':
			if (winX / winY > this.ratio) {
				mode = 'height'
				this.currentMode = (winY < this.imgY) ? 'height' : 'auto';
			} else {
				mode = 'width'
				this.currentMode = (winX < this.imgX) ? 'width' : 'auto';
			}
			cssX = Math.min(winX, this.imgX).toString() + 'px';
			cssY = Math.min(winY, this.imgY).toString() + 'px';
			break;

		  case 'expand':
			if (winX / winY > this.ratio) {
				mode = 'height'
				this.currentMode = (winY > this.imgY) ? 'height' : 'auto';
			} else {
				mode = 'width'
				this.currentMode = (winX > this.imgX) ? 'width' : 'auto';
			}
			cssX = Math.max(winX, this.imgX).toString() + 'px';
			cssY = Math.max(winY, this.imgY).toString() + 'px';
			break;

		  default:
			this.currentMode = mode;
			cssX = winX.toString() + 'px';
			cssY = winY.toString() + 'px';
		}

		// ۂɃTCY
		switch (mode) {
		  case 'full':
			this.picture.style.width = cssX;
			this.picture.style.height = cssY;
			break;

		  case 'width':
			this.picture.style.width = cssX;
			this.picture.style.height = 'auto';
			break;

		  case 'height':
			this.picture.style.width = 'auto';
			this.picture.style.height = cssY;
			break;

		  default:
			break;
		}
	}
}

// }}}
// {{{ fiShowHide()

/*
 * {^̕\E\؂ւ
 */
function fiShowHide(display)
{
	var sw = document.getElementById('btn');
	if (!sw) {
		return;
	}
	if (typeof display == 'undefined') {
		if (sw.style.display == 'block') {
			sw.style.display = 'none';
		} else {
			sw.style.display = 'block';
		}
	} else {
		if (display) {
			sw.style.display = 'block';
		} else {
			sw.style.display = 'none';
		}
	}
}

// }}}
// {{{ fiGetImageInfo()

/*
 * f[^x[X摜擾
 *
 * @param String type
 * @param String value
 * @return void
 */
function fiGetImageInfo(type, value)
{
	var info = ic2_getinfo(type, value);
	if (!info) {
		alert('摜擾ł܂ł');
		return;
	}

	fiSetRank(info.rank);
	document.getElementById('fi_id').value = info.id.toString();
	//document.getElementById('fi_memo').value = info.memo;
}

// }}}
// {{{ fiSetRank()

/*
 * N\XV
 *
 * @param Number rank
 * @return void
 */
function fiSetRank(rank)
{
	var images = document.getElementById('fi_stars').getElementsByTagName('img');
	var pos = rank + 1;
	images[0].setAttribute('src', 'img/sn' + ((rank == -1) ? '1' : '0') + '.png');
	for (var i = 2; i < images.length; i++) {
		images[i].setAttribute('src', 'img/s' + ((i > pos) ? '0' : '1') + '.png');
	}
}

// }}}
// {{{ fiUpdateRank()

/*
 * f[^x[XɋL^Ă郉NXV
 *
 * @param Number rank
 * @return Boolean  always returns false.
 */
function fiUpdateRank(rank)
{
	var id = document.getElementById('fi_id').value;
	if (!id) {
		alert('摜IDݒ肳Ă܂');
		return false;
	}

	var objHTTP = getXmlHttp();
	if (!objHTTP) {
		alert('Error: XMLHTTP ʐMIuWFNg̍쐬Ɏs܂B') ;
		return false;
	}
	var url = 'ic2_setrank.php?id=' + id + '&rank=' + rank.toString();
	var res = getResponseTextHttp(objHTTP, url, 'nc');
	if (res == '1') {
		fiSetRank(rank);
	}
	return false;
}

// }}}
// {{{ fiOnKeyDown()

/*
 * L[ŃNύX
 *
 * @param Event evt
 * @return Boolean
 */
function fiOnKeyDown(evt)
{
	var evt = (evt) ? evt : ((window.event) ? window.event : null);
	var rank = null;
	if (evt === null || typeof evt.keyCode == 'undefined') {
		return true;
	}
	if (evt.altKey || evt.ctrlKey || evt.metaKey || evt.shiftKey) {
		return true;
	}
	window.focus();

	switch (evt.keyCode) {
		// NύX
		case 48: // '0'
		case 49: // '1'
		case 50: // '2'
		case 51: // '3'
		case 52: // '4'
		case 53: // '5'
			rank = evt.keyCode - 48;
			break;

		// NύX (eL[)
		case  96: // '0'
		case  97: // '1'
		case  98: // '2'
		case  99: // '3'
		case 100: // '4'
		case 101: // '5'
			rank = evt.keyCode - 96;
			break;

		// ځ[
		case   8: // BS
		case 127: // DEL
			rank = -1;
			break;
	}

	if (rank !== null) {
		fiUpdateRank(rank);
		fiShowHide(true);
	}

	if (typeof evt.stopPropagation != 'undefined') {
		evt.stopPropagation();
	} else {
		evt.cancelBubble = true;
	}
	if (typeof evt.preventDefault != 'undefined') {
		evt.preventDefault();
	} else {
		evt.returnValue = false;
	}

	return false;
};

// L[Cxgɓo^
if (typeof document.addEventListener != 'undefined') {
	document.addEventListener('keydown', fiOnKeyDown, false);
} else if (typeof document.attachEvent != 'undefined') {
	document.attachEvent('onkeydown', fiOnKeyDown);
} else {
	document.onkeydown = fiOnKeyDown;
}

// }}}
// {{{ fiSetup()

/*
 * FitImageZbgAbv
 *
 * @param Number width
 * @param Number height
 * @param String autofit
 * @param String infoKeyType
 * @param String infoKeyValue
 * @return void
 */
function fiSetup(width, height, autofit, infoKeyType, infoKeyValue)
{
	var $, fi, img;

	if (typeof(width) !== 'number' || width < 1 ||
		typeof(height) !== 'number' || height < 1) {
		alert('FitImagẽZbgAbvs: 摜TCYsł');
		return;
	}

	window.focus();

	$ = function(id){
		return document.getElementById(id);
	};

	img = $('picture');

	fi = new FitImage(img, width, height);
	if (autofit && autofit !== '') {
		fi.fitTo(autofit);
	}

	img.onclick = function(evt){
		if (fiTimer) {
			clearTimeout(fiTimer);
		}
		fiTimer = setTimeout('fiShowHide(); fiTimer = null;', 250);
	};

	img.ondblclick = function(evt){
		if (fiTimer) {
			clearTimeout(fiTimer);
			fiTimer = null;
		}
		if (fi.currentMode == 'auto') {
			fi.fitTo(fi.defaultMode);
		} else {
			fi.fitTo(fi.currentMode);
		}
	};

	//$('fi_fit_xy').onclick = function(evt){ fi.fitTo('full'); };
	$('fi_fit_x').onclick = function(evt){ fi.fitTo('width'); };
	$('fi_fit_y').onclick = function(evt){ fi.fitTo('height'); };

	fiGetImageInfo(infoKeyType, infoKeyValue);

	if ($('fi_id').value != '') {
		var stars = $('fi_stars').getElementsByTagName('img');
		for (var i = 0; i < stars.length; i++) {
			stars[i].onclick = (function(n){
				return function(){ fiUpdateRank(n); };
			})(i - 1);
		}
	}
}

// }}}

/*
 * Local Variables:
 * mode: javascript
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: t
 * End:
 */
/* vim: set syn=javascript fenc=cp932 ai noet ts=4 sw=4 sts=4 fdm=marker: */
