<?php
/**
 * t@C𑀍삷NX
 * static\bhŗp
 */
class FileCtl
{
    /**
     * t@CȂΐA݌Ȃ΃p[~bV𒲐
     * iɃt@CA݌ꍇ́AȂBmodified̍XVȂj
     *
     * @static
     * @access  public
     *
     * @param   boolean  $die  true ȂAG[łɏI
     * @return  boolean  肪Ȃtrue
     */
    function make_datafile($file, $perm = 0606, $die = true)
    {
        $me = __CLASS__ . "::" . __FUNCTION__ . "()";
        
        // `FbN
        if (strlen($file) == 0) {
            trigger_error("$me, file is null", E_USER_WARNING);
            return false;
        }
        if (empty($perm)) {
            trigger_error("$me, empty perm. ( $file )", E_USER_WARNING);
            $die and die("Error: $me, empty perm");
            return false;
        }
        
        // t@CȂ
        if (!file_exists($file)) {
            if (!FileCtl::mkdirFor($file)) {
                $die and die("Error: $me -> FileCtl::mkdirFor() failed.");
                return false;
            }
            if (!touch($file)) {
                $die and die("Error: $me -> touch() failed.");
                return false;
            }
            chmod($file, $perm);
        
        // t@C
        } else {
            if (!is_writable($file)) {
                if (false === $cont = file_get_contents($file)) {
                    $die and die("Error: $me -> file_get_contents() failed.");
                    return false;
                }
                unlink($file);
                if (false === file_put_contents($file, $cont, LOCK_EX)) {
                    // Y: $file  null̎Afile_put_contents() falseԂwaring͏oȂ̂Œ
                    // ł $file ͖񑩂Ă邪c
                    $die and die("Error: $me -> file_put_contents() failed.");
                    return false;
                }
                chmod($file, $perm);
            }
        }
        return true;
    }
    
    /**
     * wfBNgȂ΁iċAIɁjāAp[~bV̒s
     * PHP 5.0.0 ȏł΁Amkdir()  recursive p[^ǉĂB  
     *
     * @access  public
     * @param   integer  $perm  p[~bV ex) 0707
     * @param   boolean  $die   true ȂAG[_ŁAdie
     * @return  boolean  sہBɃfBNg݂Ă鎞trueԂB
     */
    function mkdirR($dir, $perm = null, $die = true)
    {
        return FileCtl::_mkdirR($dir, $perm, $die, 0);
    }
    
    /**
     * mkdirR() ̎s
     * [todo] die͂Ȃ
     *
     * @access  private
     * @param   integer  $rtimes  ċAĂяoĂ錻݉
     * @return  boolean
     */
    function _mkdirR($dir, $perm = null, $die = true, $rtimes = 0)
    {
        global $_conf;
        
        $me = __CLASS__ . "::" . __FUNCTION__ . "()";
        
        // G[
        if (strlen($dir) == 0) {
            trigger_error("$me cannot mkdir. no dirname", E_USER_WARNING);
            $die and die('Error');
        }
        
        // ɃfBNg݂Ă鎞́Â܂܂OK
        if (is_dir($dir)) {
            return true;
        }
        
        if (empty($perm)) {
            $perm = empty($_conf['data_dir_perm']) ? 0707 : $_conf['data_dir_perm'];
        }
        
        $dir_limit = 50; // eKw鐧
        
        // ċA߃G[
        if ($rtimes > $dir_limit) {
            trigger_error("$me cannot mkdir. ($dir) too match up dir! I'm very tired.", E_USER_WARNING);
            $die and die('Error');
            return false;
        }
        
        // eɍċAs
        if (false === FileCtl::_mkdirR(dirname($dir), $perm, $die, ++$rtimes)) {
            $die and die('Error: FileCtl::_mkdirR()');
            return false;
        }
        
        if (!mkdir($dir, $perm)) {
            trigger_error("$me -> mkdir failed, $dir", E_USER_WARNING);
            $die and die('Error: mkdir()');
            return false;
        }
        chmod($dir, $perm);

        return true;
    }
    
    /**
     * w肵pX̐efBNgȂ΁iċAIɁjāAp[~bV̒s
     * mkdirR()dirname()đĂ邾Ȃ̂ŁÃ\bh͂ȂĂȂB 
     *
     * @static
     * @access  public
     * @return  boolean
     */
    function mkdirFor($apath)
    {
        return FileCtl::mkdirR(dirname($apath));
    }
    
    // {{{ file_read_lines()

    /**
     * t@CŜǂݍŔzɊi[
     * G[}t @file() ̑p
     *
     * @static
     * @access  public
     * @param string $filename
     * @param int $flags
     * @param resource $context
     */
    function file_read_lines($filename, $flags = 0, $context = null)
    {
        if (!is_readable($filename)) {
            return false;
        }
        $lines = file($filename, $flags, $context);
        if (($flags & FILE_IGNORE_NEW_LINES) && $lines &&
            strlen($lines[0]) && substr($lines[0], -1) == "\r")
        {
            $lines = array_map(create_function('$l', 'return rtrim($l, "\\r");'), $lines);
            if ($flags & FILE_SKIP_EMPTY_LINES) {
                $lines = array_filter($lines, 'strlen');
            }
        }
        return $lines;
    }

    // }}}
    
    /**
     * gzt@C̒g擾
     *
     * @static
     * @access  public
     * @return  string|false
     */
    function getGzFileContents($filepath)
    {
        if (is_readable($filepath)) {
            /*
            ob_implicit_flush(false);
            ob_start();
            readgzfile($filepath);
            $contents = ob_get_contents();
            ob_end_clean();
            return $contents;
            */
            return implode('', gzfile($filepath));
        }
        
        return false;
    }
    
    /**
     * VXeR}hŃt@Cgzip𓀂sihoge.txt.gz  hoge.txtj
     *
     * @static
     * @access  public
     * @return  boolean
     */
    function ungzipWithSystemCommand($gzfile, $bakfile)
    {
        // ungzt@Cɑ݂ȂꎞIɃobNAbvđޔ
        $ungzfile = rtrim($gzfile, '.gz');
        if (file_exists($ungzfile)) {
            file_exists($bakfile) and unlink($bakfile);
            rename($ungzfile, $bakfile);
        }
        
        // 𓀂ihoge.txt.gz  hoge.txt ɕϊj
        $rcode = 1;
        system(sprintf('gzip -d %s', escapeshellarg($gzfile)), $rcode);
        
        // 𓀎sȂobNAbv߂
        if ($rcode != 0) {
            if (file_exists($bakfile)) {
                file_exists($ungzfile) and unlink($ungzfile); // ϊst@C폜
                rename($bakfile, $ungzfile);
            }
            return false;
        }
        // 𓀐
        file_exists($bakfile) and unlink($bakfile);
        return true;
    }
    
    /**
     * Windowsł͏㏑ rename() ŃG[o悤Ȃ̂ŁÃG[rename()
     * Aunlink()  rename() ̊ԂňůԂ󂭂̂ŊSł͂ȂB
     * Ql http://ns1.php.gr.jp/pipermail/php-users/2005-October/027827.html
     *
     * @return  boolean
     */
    function rename($src_file, $dest_file)
    {
        $win = (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') ? true : false;
        
        if ($win) {
            if (file_exists($dest_file) and is_writable($dest_file) and unlink($dest_file)) {
                return rename($src_file, $dest_file);
            } else {
                return false;
            }
        }
        return rename($src_file, $dest_file);
    }
    
    /**
     * ݒ̕sSȃt@Ceǂݎ邱Ƃ̂Ȃ悤ɁAꎞt@Cɏł烊l[B
     * AWindows̏ꍇ́A㏑renamesSƂȂ̂ŒڏނƂƂB
     * $tmp_pathňꎞt@CpXw肵ȂꍇAɏ݂ƋL^͕̏ۏ؂ȂB
     *
     * @static
     * @access  public
     * @param   string   $tmp_dir   ꎞۑfBNg̎wB
     * @param   string   $tmp_path  ifBNg܂߂jꎞۑt@CpX̖wBw肵ꍇA$tmp_dir ͖ƂȂB
     * @return  boolean  s  iɏ݃oCgԂӖ͂قƂǂȂƎvj
     */
    function filePutRename($file, $cont, $tmp_dir = null, $tmp_path = null)
    {
        if (!strlen($file)) {
            trigger_error(__CLASS__ . '::' . __FUNCTION__ . '(), file is null', E_USER_WARNING);
            return false;
        }
        
        $win = (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') ? true : false;
        
        
        if (strlen($tmp_path)) {
            $write_file = $win ? $file : $tmp_path;
            
        } else {
            // ꎞfBNg̖w肪ꍇ
            if (strlen($tmp_dir)) {
                if (!is_dir($tmp_dir)) {
                    trigger_error(__FUNCTION__ . "() -> is_dir($tmp_dir) failed.", E_USER_WARNING);
                    return false;
                }
            } else {
                if (isset($GLOBALS['_conf']['tmp_dir'])) {
                    $tmp_dir = $GLOBALS['_conf']['tmp_dir'];
                    if (!is_dir($tmp_dir)) {
                        if (false === FileCtl::mkdirR($tmp_dir)) {
                            return false;
                        }
                    }
                } else {
                    // 2006/10/05 php_get_tmpdir()  might be only in CVS
                    // $tmp_dir = php_get_tmpdir();

                    // nullł''łAtempnam()ŃVXẽe|fBNggp邪Ał̂B
                    // 2007/01/22 WinłNG?mF
                    $tmp_dir = null;
                }
            }

            // tempnam()ō쐬t@C̃p[~bV0600ɂȂ
            $write_file = $win ? $file : tempnam($tmp_dir, $prefix = 'rename_');
        }
        
        
        if (!$fp = fopen($write_file, 'ab+')) {
            return false;
        }
        if (!flock($fp, LOCK_EX)) {
            return false;
        }
        //rewind($fp);
        if (!ftruncate($fp, 0)) {
            return false;
        }
        if (strlen($cont)) {
            if (!fwrite($fp, $cont)) {
                return false;
            }
        }
        //ftruncate($fp, ftell($fp));

        if (!$win) {
            if (!rename($write_file, $file)) {
                return false;
            }
        }
        
        flock($fp, LOCK_UN);
        fclose($fp);
        
        /*
        if (false === $r = file_put_contents($write_file, $cont, LOCK_EX)) {
            return false;
        }
        if (!$win) {
            if (!rename($write_file, $file)) {
                return false;
            }
        }
        */
        
        return true;
    }
    
    // {{{ scandirR()

    /**
     * ċAIɃfBNg𑖍
     *
     * Xgt@CƃfBNgɕĕԂBꂻ̃Xg͒PȔz
     *
     * @static
     * @access  public
     * @return  array|false
     */
    function scandirR($dir)
    {
        $dir = realpath($dir);
        $list = array('files' => array(), 'dirs' => array());
        $files = scandir($dir);
        if ($files === false) {
            return false;
        }
        foreach ($files as $filename) {
            if ($filename == '.' || $filename == '..') {
                continue;
            }
            $filename = $dir . DIRECTORY_SEPARATOR . $filename;
            if (is_dir($filename)) {
                $child = FileCtl::scandirR($filename);
                if ($child) {
                    $list['dirs'] = array_merge($list['dirs'], $child['dirs']);
                    $list['files'] = array_merge($list['files'], $child['files']);
                }
                $list['dirs'][] = $filename;
            } else {
                $list['files'][] = $filename;
            }
        }
        return $list;
    }

    // }}}
    // {{{ garbageCollection()

    /**
     * ЂƂ̃KxR
     *
     * $targetDirŏIXV$lifeTimebȏソt@C폜
     *
     * @access  public
     * @param   string   $targetDir  K[xbWRNVΏۃfBNg
     * @param   integer  $lifeTime   t@C̗Libj
     * @param   string   $prefix     Ώۃt@C̐ړiIvVj
     * @param   string   $suffix     Ώۃt@C̐ڔiIvVj
     * @param   boolean  $recurive   ċAIɃK[xbWRNV邩ۂiftHgłFALSEj
     * @return  array|false    폜ɐt@CƎst@CʁXɋL^񎟌̔z
     */
    function garbageCollection($targetDir, $lifeTime, $prefix = '', $suffix = '', $recursive = FALSE)
    {
        if (!strlen($targetDir)) {
            return false;
        }
        $result = array('successed' => array(), 'failed' => array(), 'skipped' => array());
        $expire = time() - $lifeTime;
        //t@CXg擾
        if ($recursive) {
            $list = FileCtl::scandirR($targetDir);
            if ($list === false) {
                return false;
            }
            $files = &$list['files'];
        } else {
            $list = scandir($targetDir);
            $files = array();
            $targetDir = realpath($targetDir) . DIRECTORY_SEPARATOR;
            foreach ($list as $filename) {
                if ($filename == '.' || $filename == '..') { continue; }
                $files[] = $targetDir . $filename;
            }
        }
        //p^[ݒi$prefix$suffixɃXbV܂܂Ȃ悤Ɂj
        if ($prefix || $suffix) {
            $prefix = (is_array($prefix)) ? implode('|', array_map('preg_quote', $prefix)) : preg_quote($prefix);
            $suffix = (is_array($suffix)) ? implode('|', array_map('preg_quote', $suffix)) : preg_quote($suffix);
            $pattern = '/^' . $prefix . '.+' . $suffix . '$/';
        } else {
            $pattern = '';
        }
        //KxRJn
        foreach ($files as $filename) {
            if ($pattern && !preg_match($pattern, basename($filename))) {
                //$result['skipped'][] = $filename;
                continue;
            }
            if (filemtime($filename) < $expire) {
                if (@unlink($filename)) {
                    $result['successed'][] = $filename;
                } else {
                    $result['failed'][] = $filename;
                }
            }
        }
        return $result;
    }

    // }}}
}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
