<?php
/* vim: set fileencoding=cp932 ai et ts=4 sw=4 sts=0 fdm=marker: */
/* mi: charset=Shift_JIS */

require_once 'PEAR.php';
require_once dirname(__FILE__) . '/search.class.php';

class GoogleSearch_PHP5 extends GoogleSearch_Common
{
    // {{{ constructor

    /**
     * RXgN^
     *
     * @return void
     * @access public
     */
    function __construct()
    {
    }

    // }}}
    // {{{ init()

    /**
     * SOAPNCAg̃CX^X𐶐
     *
     * @param string $wsdl  Google Search WSDLt@C̃pX
     * @param string $key   Google Web APIs ̃CZXL[
     * @return boolean
     * @access public
     */
    function init($wsdl, $key)
    {
        if (!file_exists($wsdl)) {
            return PEAR::raiseError('GoogleSearch.wsdl not found.');
        }
        if (!extension_loaded('soap')) {
            return PEAR::raiseError('SOAP extension not loaded.');
        }

        $this->setConf($wsdl, $key);

        try {
            $this->soapClient = &new SoapClient($wsdl);
        } catch (SoapFault $e) {
            $errfmt = 'SOAP Fault: (faultcode: %s; faultstring: %s;)';
            $errmsg = sprintf($errfmt, $e->faultcode, $e->faulstring);
            return PEAR::raiseError($errmsg);
        }

        return TRUE;
    }

    // }}}
    // {{{ doSearch()

    /**
     * s
     *
     * @param string  $q  L[[h
     * @param integer $start  ʂ擾ʒu
     * @param integer $maxResults  ʂ擾ő吔
     * @return object 
     * @access public
     */
    function &doSearch($q, $maxResults = 10, $start = 0)
    {
        $params = $this->prepareParams($q, $maxResults, $start);
        try {
            $result = call_user_func_array(array($this->soapClient, 'doGoogleSearch'), $params);
        } catch (SoapFault $e) {
            $errfmt = 'SOAP Fault: (faultcode: %s; faultstring: %s;)';
            $errmsg = sprintf($errfmt, $e->faultcode, $e->faulstring);
            return PEAR::raiseError($errmsg);
        }
        return $result;
    }

    // }}}
}

?>
