' Attribute VB_Name = "Logger"
Option Explicit
'----------------------------------------------
'! @brief Ô݂߂̃NXB
'!	@code
'!	Set logger = New XLogger
'!	logger.write(msg)
'! @endcode
'!	@description '		Ot@Cw肵ĂȂ΃XNvĝfBNgɏo͂B
'!	̂Ƃ̃Ot@C<XNvg{>-yyyyMMdd.log<br />
'!	Ot@C쐬łȂ or NbNĂ ̏ꍇA10ĎsĎgȂ΃XNvgI
Class XLogger

	Private mLogFileName	' As String '* Ot@C̖OB
	Private mLogLevel ' As Integer '* Oo̓x

	'----------------------------------------------
	'* @brief Ot@C̐ݒ
	'----------------------------------------------
	Public Sub setFileName(filename)
		Dim fn
		fn = replaceDateSymbols(filename)

		mLogFileName = fn
	End Sub

	'----------------------------------------------
	'* @brief Ȍo
	'*	@param msg o
	'----------------------------------------------
	Public Sub write(msg)
		On Error Resume Next
		If mLogLevel = LOGLEVEL_NONE Then Exit Sub
		
	 	dim fso
	 	dim fo
	 	Set fso = CreateObject("Scripting.FileSystemObject")
	 	
	 	Set fo = openLogFile(fso)
	 	If(Err.Number <> 0) Then
	 		WScript.Echo "open file failed " & mLogFileName & vbCrLf & Err.Description
	 	End If
	 	fo.WriteLine FormatDate(Now(),"yyyy/MM/dd HH:mm:ss") & " " & msg
	 	If(Err.Number <> 0) Then
	 		WScript.Echo Err.Description
	 	End If
	 	fo.Close
	 	Set fo = Nothing
	 	Set fso = Nothing
	end sub
	'----------------------------------------------
	'* @brief 	Ot@CJ
	'----------------------------------------------
	Function openLogFile(fso)
		On Error Resume Next
		Dim fo
		Dim retry
		
		Set fo = Nothing
		retry = 0
	 	Do While (fo is Nothing)
		 	Set fo = fso.OpenTextFile(mLogFileName,ForAppending, True)
		 	Select Case Err.Number
		 	Case  0 'J
		 		Exit Do
		 	Case 76 ' pXȂ(ݒ~X)
		 		WScript.Echo "open file failed " & mLogFileName & vbCrLf & Err.Number & ":" & Err.Description
	 			WScript.Quit -1
			Case 70 ' ߂Ȃ(ROANbNĂ)
		 		retry = retry + 1
		 		If retry >= 10 Then
		 			'10ă_ȂoȂBGۂŊJoJȂ񂩒mȂ
		 			WScript.Echo "open file failed " & mLogFileName & vbCrLf & Err.Number & ":" & Err.Description
		 			WScript.Quit -1
		 		End If
		 		WScript.Sleep 100
		 	Case Else
	 			WScript.Echo "open file failed " & mLogFileName & vbCrLf & Err.Number & ":" & Err.Description
	 			WScript.Quit -1
			End Select
	 	Loop

		Set openLogFile = fo
		Err.Clear
	End Function
	
	'----------------------------------------------
	'* @brief 	fobObZ[Wo
	'----------------------------------------------
	Public Sub Debug(msg)
		If mLogLevel > 1 Then Exit Sub
		
		write "DEBUG:" & msg 
	End Sub
	'----------------------------------------------
	'* @brief 	񃁃bZ[Wo
	'----------------------------------------------
	Public Sub Info(msg)
		If mLogLevel > LOGLEVEL_INFO Then Exit Sub
		
		write "INFO:" & msg 
	End Sub
	'----------------------------------------------
	'* @brief 	xbZ[Wo
	'----------------------------------------------
	Public Sub Warning(msg)
		If mLogLevel > LOGLEVEL_WARNING Then Exit Sub
		
		write "WARNING:" & msg 
	End Sub
	'----------------------------------------------
	'* @brief 	G[bZ[Wo
	'----------------------------------------------
	Public Sub Error(msg)
		If mLogLevel > LOGLEVEL_ERROR Then Exit Sub
		
		write "ERROR:" & msg 
	End Sub

	Public Sub Class_Initialize()
		'ftHg=XNvg{{yyyyMMdd+.log
		Dim basePath
		Dim fileNameFormat
		basePath = ScriptProperties.Item("LogFile.Path")
		If(basePath = "") Then
			basePath = getScriptPath
		End IF
		createDirectory basePath ,Array()
		
		Dim filePrefix
		filePrefix = ScriptProperties.Item("LogFile.Prefix")
		If(filePrefix = "") Then
			filePrefix = getScriptBaseName 
		End IF

		mLogFileName = combinPath(basePath,replaceDateSymbols(filePrefix & "_%y%M%d.log"))
		
		mLogLevel = CInt( ScriptProperties.Item("LogFile.LogLevel") )
	End Sub

	'* @brief  w蕶ɏ]ĕҏWB
	'* @note  bash::date -s ̓ɏ]B
	Private Function replaceDateSymbols(str)
		Dim fn
		Dim dt
		dt = Now

		fn = Replace(str,"%y",Right("0000" & Year(dt) ,4) )
		fn = Replace(fn,"%M",Right("00" & Month(dt) ,2) )
		fn = Replace(fn,"%d",Right("00" & Day(dt) ,2) )
		fn = Replace(fn,"%H",Right("00" & Hour(dt) ,2) )
		fn = Replace(fn,"%m",Right("00" & Minute(dt) ,2) )
		fn = Replace(fn,"%s",Right("00" & Second(dt) ,2) )

		replaceDateSymbols = fn
	End Function
End Class
'----------------------------------------------
'*	ftHg̃K[
'----------------------------------------------
Dim Logger
Set Logger = new XLogger
