' Attribute VB_Name = "DateFormatter"
'!	@brief t^
Class DateFormatter
	'-----------------------------------------------------------
	'* @brief t^ yyyy/MM/dd HH:mm:ss
	'* @param obj Date̒l
	'* @param formatString	tH[}bgBjava.text.SimpleDateFormatɏ]
	'*		yyyy 4̐
	'*		yy	2
	'*		MM	(K20)
	'*		M	(0O)
	'*		dd	(K20)
	'*		d	(0O)
	'*		hh	(K2024)
	'*		mm	(K20)
	'*		ss	b(K20)
	'-----------------------------------------------------------
	Public Function Format(obj,formatString)
		Dim fmt
		If IsEmpty(formatString) Then
			fmt = "yyyy/MM/dd HH:mm:ss"
		ElseIf formatString = "" Then
			fmt = "yyyy/MM/dd HH:mm:ss"
		Else
			fmt = formatString
		End If
		Format = FormatDate(obj,fmt)
	End Function
	'-----------------------------------------------------------
	'* @brief t^ҏW yyyy/MM/dd HH:mm:ss
	'* @param invalue Date̒l
	'*		fmt	tH[}bgBjava.text.SimpleDateFormatɏ]
	'*		yyyy 4̐
	'*		yy	2
	'*		MM	(K20)
	'*		M	(0O)
	'*		dd	(K20)
	'*		d	(0O)
	'*		hh	(K2024)
	'*		mm	(K20)
	'*		ss	b(K20)
	'-----------------------------------------------------------
	Public Function FormatDate(invalue,fmt)
		Dim buf 

		If IsNull(invalue) Then
			FormatDate = Null
			Exit Function
		End If
		buf = fmt

		If InStr(buf,"yyyy") > 0 Then
			buf = Replace(buf,"yyyy", Right("0000" & CStr(Year(invalue)),4) )
		End If

		If InStr(buf,"yy") > 0 Then
			buf = Replace(buf,"yy", Right("0000" & CStr(Year(invalue)),2) )
		End If
		If InStr(buf,"MM") > 0 Then
			buf = Replace(buf,"MM", Right("00" & CStr(Month(invalue)),2) )
		End If
		If InStr(buf,"M") > 0 Then
			buf = Replace(buf,"M", CStr(Month(invalue)) )
		End If
		If InStr(buf,"dd") > 0 Then
			buf = Replace(buf,"dd", Right("00" & CStr(Day(invalue)),2) )
		End If
		If InStr(buf,"d") > 0 Then
			buf = Replace(buf,"d", CStr(Day(invalue)) )
		End If

		If InStr(buf,"HH") > 0 Then
			buf = Replace(buf,"HH", Right("00" & CStr(Hour(invalue)),2) )
		End If
		If InStr(buf,"mm") > 0 Then
			buf = Replace(buf,"mm", Right("00" & CStr(Minute(invalue)),2) )
		End If
		If InStr(buf,"ss") > 0 Then
			buf = Replace(buf,"ss", Right("00" & CStr(Second(invalue)),2) )
		End If


		FormatDate = buf
	End Function

End Class
