<?php
class Mini_Data_Error{
	var $sqlState;
	var $errorCode;
	var $message;
	
	/**
	 * errorInfoから構築
	 * @param unknown_type $errorInfo
	 * @return unknown_type
	 */
	public function __construct($errorInfo = null){
		$this->sqlState = "";
		$this->errorCode = "";
		$this->message = "";
		
		if($errorInfo != null){
			$this->fromPdoErrorInfo($errorInfo);
		}
	}
	public function fromPdoErrorInfo($errorInfo){
		$count = count($errorInfo);
		if($count >= 1) $this->sqlState = $errorInfo[0];
		if($count >= 2)$this->errorCode = $errorInfo[1];
		if($count >= 3)$this->message = $errorInfo[2];
	}
	public function isError(){
		if($this->sqlState == "") return false;
		if($this->sqlState == "00000") return false;
		
		return true;
	}
}