<?php
Mini_Loader::loadClass("Mini_Config");
Mini_Loader::loadClass("Mini_Data_Command");
class Mini_Data_Connection{
	var $config;
	var $handle;
	var $connectCount;
	var $transactionCount;
	
	public function __construct(){
		
	}
	public static function getConnection($names = array()){
		//$names はCFWとの互換の為だけ。使わない
		$config = Mini_Config::load("connection")->connection->default;
		$connection = new Mini_Data_Connection();
		$connection->config = $config;
		
		return $connection;
		
	}
	public function connect(){
		$dsn = $this->buildDsn();
		$this->handle = new PDO($dsn);
	}
	public function disconnect(){
		$this->handle = null;
	}
	private function buildDsn(){
		$dsn = "";
		$config = $this->config;
		$dsn .= $config->driver . ":";
		$dsn .= "host={$config->host}";
		$dsn .= " port={$config->port}";
		$dsn .= " dbname={$config->dbname}";
		if($config->user != "") $dsn .= " user={$config->user}";
		if($config->password != "") $dsn .= " password={$config->password}";

		return $dsn;
		
	}
	public function query($queryString){
		echo $queryString;
		$st = $this->handle->query($queryString);
		$result = $st->fetchAll();
		return $result;
	}
	public function createCommand($text,$parameter = array()){
		$command = new Mini_Data_Command($text,$parameter);
		$command->setConnection($this);
		return $command;
	}
}