<?php
/**
 * Tree Nodeを表現するインターフェース.
 * @author okada
 * @package CFW_Models
 */
interface CFW_Models_ITreeNode{
    function getName();
    function setName($name);
    function getParent();
    function setParent($parent);
    function getChild($name);
    function getChildren();
    function setChildren($children);
    /**
	 * 子要素を追加する
	 * @param CFW_Models_ITreeNode $node
	 * @return unknown_type
	 */
	function appendChild(CFW_Models_ITreeNode $node);
	/**
	 * 子要素を削除する
	 * @param CFW_Models_ITreeNode $node
	 * @return unknown_type
	 */
	function removeChilde(CFW_Models_ITreeNode $node);
	/**
	 * このオブジェクトが指定ノードの先祖かどうか
	 * @param CFW_Models_ITreeNode $node
	 * @return unknown_type
	 */
	function isAncestorOf(CFW_Models_ITreeNode $node);
	/**
	 * このオブジェクトが指定ノードの子孫かどうか
	 * @param CFW_Models_ITreeNode $node
	 * @return unknown_type
	 */
	function isDescendantOf(CFW_Models_ITreeNode $node);
	/**
	 * パスを文字列として表現する
	 * @return String
	 */
	function pathString();
	/**
	 * パスを配列で返す
	 * @return CFW_Models_ITreeNode
	 */
	function path();
	/**
	 * 指定パスのノードを見つける
	 * @param array $path
	 * @return CFW_Models_ITreeNode
	 */
	function find($path = array());
}