<?php
Zend_Loader::loadClass("CFW_Auth_Hash");
/**
 * SaltedSHA1実装
 * @author okada
 * @package CFW_Auth_Hash
 */
class CFW_Auth_Hash_SSha1 extends CFW_Auth_Hash{
    public function createHash($input){
        $salt = CFW_Util_String::randomString($this->config->saltLength);

        $hashed = sha1($input . $salt,true);
        return $this->encode( $hashed . $salt );
    }
    public function verify($input,$target){
        $decoded = $this->decode($target);
        $decodedLength = strlen( $decoded );
        $salt = substr( $decoded,$decodedLength - $this->config->saltLength,$this->config->saltLength);
        $hashed = $this->encode( sha1($input.$salt,true) . $salt);

        $result =  ($hashed == $target);

        return $result;
    }

}