﻿<?php
Zend_Loader::loadClass("CFW_FieldProperties_Abstract");
Zend_Loader::loadClass("CFW_Data_TableProperty");

/**
* table usersに対応するフィールドプロパティ
*/
class CFW_Sample_Model_Base_UsersTableProperty extends  CFW_Data_TableProperty
{
	/* var FieldProperty [user_id] */
	public $userId;
	/* var FieldProperty [password] */
	public $password;
	/* var FieldProperty [user_name] */
	public $userName;
	/* var FieldProperty [num_fields] */
	public $numFields;
	/* var FieldProperty [birthday] */
	public $birthday;
	/* var FieldProperty [created_at] */
	public $createdAt;
	/* var FieldProperty [modified_at] */
	public $modifiedAt;
	

    /**
    * default construct
    */
    public function __construct()
    {
    	$this->tableName = "users";
		$this->userId = CFW_FieldProperties_Abstract::NewInstance("varchar", "users", "user_id","[user_id]", 50, 0, 0, false, "",true);
		$this->password = CFW_FieldProperties_Abstract::NewInstance("varchar", "users", "password","[password]", 128, 0, 0, true, "",false);
		$this->userName = CFW_FieldProperties_Abstract::NewInstance("varchar", "users", "user_name","[user_name]", 100, 0, 0, true, "",false);
		$this->numFields = CFW_FieldProperties_Abstract::NewInstance("int", "users", "num_fields","[num_fields]", 4, 10, 0, true, null,false);
		$this->birthday = CFW_FieldProperties_Abstract::NewInstance("datetime", "users", "birthday","[birthday]", 16, 23, 3, true, null,false);
		$this->createdAt = CFW_FieldProperties_Abstract::NewInstance("datetime", "users", "created_at","[created_at]", 16, 23, 3, true, null,false);
		$this->modifiedAt = CFW_FieldProperties_Abstract::NewInstance("datetime", "users", "modified_at","[modified_at]", 16, 23, 3, true, null,false);
		

		$this->entityClass = "CFW_Sample_Model_Base_UsersTableRow";
 		
    }

    /**
    * 全てのフィールドを列挙
    * 
    * @returns 
    */
    public function getFields()
    {
    	$fields = array();
		$fields[] = $this->userId;
		$fields[] = $this->password;
		$fields[] = $this->userName;
		$fields[] = $this->numFields;
		$fields[] = $this->birthday;
		$fields[] = $this->createdAt;
		$fields[] = $this->modifiedAt;
		
		return $fields;
    }
    /**
    * 全ての主キーを列挙
    * 
    * @returns 
    */
    public function getPrimaryKeys()
    {
    	$fields = array();
        $fields[] = $this->userId;
        
		return $fields;
    }
    public function getUpdateFields(){
    	$fields = array();
		if($this->userId->doUpdate && !$this->userId->isIdentity)$fields[] = $this->userId;
		if($this->password->doUpdate && !$this->password->isIdentity)$fields[] = $this->password;
		if($this->userName->doUpdate && !$this->userName->isIdentity)$fields[] = $this->userName;
		if($this->numFields->doUpdate && !$this->numFields->isIdentity)$fields[] = $this->numFields;
		if($this->birthday->doUpdate && !$this->birthday->isIdentity)$fields[] = $this->birthday;
		if($this->createdAt->doUpdate && !$this->createdAt->isIdentity)$fields[] = $this->createdAt;
		if($this->modifiedAt->doUpdate && !$this->modifiedAt->isIdentity)$fields[] = $this->modifiedAt;
		
		return $fields;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getName()
     */
    public function getName(){
        return $this->tableName;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setName($value)
     */
    public function setName($value){
        $this->talbeName = $value;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getAlias()
     */
    public function getAlias(){
        return $this->alias;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setAlias($value)
     */
    public function setAlias($value){
        $this->alias= $value;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setDoUpdate($doUpdate)
     */
    public function setDoUpdate($doUpdate = true){
		$this->userId->doUpdate = $doUpdate;
		$this->password->doUpdate = $doUpdate;
		$this->userName->doUpdate = $doUpdate;
		$this->numFields->doUpdate = $doUpdate;
		$this->birthday->doUpdate = $doUpdate;
		$this->createdAt->doUpdate = $doUpdate;
		$this->modifiedAt->doUpdate = $doUpdate;
		
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getEntityClass()
     */
    public function getEntityClass(){
        return $this->entityClass;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getIdentityField()
     */
    public function getIdentityField(){
        return $this->identityField;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getCreatedAtField()
     */
    public function getCreatedAtField(){
        return $this->createdAtField;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getModifiedField()
     */
    public function getModifiedAtField(){
        return $this->modofiedAtField;
    }

    
}
