<?php
Zend_Loader::loadClass("CFW_Models_IEntityProperty");

/**
 * EntityPropertyの基本実装
 * @author okada
 * @package CFW_Models
 */
class CFW_Models_EntityProperty implements CFW_Models_IEntityProperty{
    /**
     * @var String
     */
    var $schema;
    /**
     * @var string
     */
    var $entityName;
    /**
     * @var string
     */
    var $alias;
    /**
     * @var String
     */
    var $entityClass;

    /**
     * @var Array
     */
    var $_fields;
    /**
     * @var Array
     */
    var $_primaryKeys;
    /**
     * @var String
     */
    var $identityField = "";
     /**
      * @var String
      */
    var $createdAtField = "created_at";
    /**
     * @var String
     */
    var $modofiedAtField = "modified_at";
    public function __construct($schema,$entityName){
        $this->schema = $schema;
        $this->entityName = $entityName;
        $this->entityClass = "CFW_Models_Entity";
        $this->_fields = array();
        $this->_primaryKeys = array();
    }
    /**
     * @param unknown_type $name
     * @param unknown_type $value
     * @return unknown
     */
    public function __set($name,$value){
        return $this->_fields[$name] = $value;
    }
    /**
     * @param unknown_type $name
     * @return unknown
     */
    public function __get($name){
        if(array_key_exists($name,$this->_fields)){
            return $this->_fields[$name];
        }
        return null;
    }

    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getFields()
     */
    public function getFields(){
        return $this->_fields;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getUpdateFields()
     */
    public function getUpdateFields(){
        $updates = array();
        foreach($this->_fields as $field){
        	if($field->isIdentity) continue;
            if($field->doUpdate) $updates[$field->fieldName] = $field;
        }
        return $updates;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getPrimaryKeys()
     */
    public function getPrimaryKeys(){
        return $this->_primaryKeys;
    }
    /**
     * @param unknown_type $pkeys
     * @return unknown_type
     */
    public function setPrimaryKeys($pkeys){
        $this->_primaryKeys = $pkeys;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getName()
     */
    public function getName(){
        return $this->entityName;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setName($value)
     */
    public function setName($value){
        $this->entityName = $value;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getAlias()
     */
    public function getAlias(){
        return $this->alias;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setAlias($value)
     */
    public function setAlias($value){
        $this->alias= $value;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setDoUpdate($doUpdate)
     */
    public function setDoUpdate($doUpdate = true){
        foreach($this->_fields as $field){
           $field->doUpdate = $doUpdate;
    }

    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getEntityClass()
     */
    public function getEntityClass(){
        return $this->entityClass;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getIdentityField()
     */
    public function getIdentityField(){
        return $this->identityField;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getCreatedAtField()
     */
    public function getCreatedAtField(){
        return $this->createdAtField;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getModifiedField()
     */
    public function getModifiedAtField(){
        return $this->modofiedAtField;
    }

}