<?php
Zend_Loader::loadClass("CFW_Auth_Hash");
/**
 * SaltedSHA1実装
 * @author okada
 * @package CFW_Auth_Hash
 */
class CFW_Auth_Hash_SSha1 extends CFW_Auth_Hash{
    public function createHash($input){
        $salt = CFW_Util_String::randomString($this->config->saltLength);

        $hashed = sha1($input . $salt,true);
        return $hashed . $salt;
    }
    public function verify($input,$target){
        $decoded = $this->decode(target);
        $salt = CFW_Util_String::right($decoded,$this->config->saltLength);
        $hashed = sha1($input.$salt,true);
        $targetHash = ssubstr($decoded, 0,strlen($decoded) - $config->saltLength);

        $result =  ($hashed == $targetHash);

        return $result;
    }

}