<?php
Zend_Loader::loadClass("CFW_Acl_IRole");
Zend_Loader::loadClass("CFW_Acl_IResource");
Zend_Loader::loadClass("CFW_Acl_Privilege");

/**
 * ACLルールを表現するインターフェース
 * @author okada
 * @package CFW_Acl
 */
interface CFW_Acl_IRule{
    /**
     * リソース名取得
     * @return unknown_type
     */
    function getResourceName();
    /**
     * リソース名設定
     * @param unknown_type $value
     * @return unknown_type
     */
    function setResourceName($value);
    /**
     * ロール名取得
     * @return unknown_type
     */
    function getRoleName();
    /**
     * ロール名設定
     * @param unknown_type $value
     * @return unknown_type
     */
    function setRoleName($value);

    /**
     * 権限取得
     * @return unknown_type
     */
    function getPrivilege();
    /**
    * 権限設定
     * @param unknown_type $value
     * @return unknown_type
     */
    function setPrivilege($value);

    /**
     * 許可チェック
     * @param integer $privilege
     * @return unknown_type
     */
    function isAllowed($privilege);
    /**
     * 拒否チェック
     * @param integer $privilege
     * @return unknown_type
     */
    function isDenied($privilege);
    /**
     * 許可
     * @param integer $privilege
     * @return unknown_type
     */
    function allow($privilege);
    /**
     * 拒否
     * @param integer $privilege
     * @return unknown_type
     */
    function deny($privilege);

}