<?php
Zend_Loader::loadClass("CFW_FieldProperties_Abstract");
Zend_Loader::loadClass("CFW_Models_EntityProperty");

/**
* table acl_rulesに対応するフィールドプロパティ
*/
class CFW_Acl_Db_Models_Base_AclRulesTableProperty extends  CFW_Models_EntityProperty
{
    /* var CFW_FieldProperties_Abstract [id] */
    public $id;
    /* var CFW_FieldProperties_Abstract [resource_id] */
    public $resourceId;
    /* var CFW_FieldProperties_Abstract [role_id] */
    public $roleId;
    /* var CFW_FieldProperties_Abstract [allow_create] */
    public $allowCreate;
    /* var CFW_FieldProperties_Abstract [allow_read] */
    public $allowRead;
    /* var CFW_FieldProperties_Abstract [allow_update] */
    public $allowUpdate;
    /* var CFW_FieldProperties_Abstract [allow_delete] */
    public $allowDelete;
    /* var CFW_FieldProperties_Abstract [description] */
    public $description;
    

    /**
    * default construct
    */
    public function __construct()
    {
        $this->tableName = "acl_rules";
        $this->id =  CFW_FieldProperties_Abstract::newInstance("int", "acl_rules", "id","[id]", 4, 10, 0, false, 0,true);
        $this->resourceId =  CFW_FieldProperties_Abstract::newInstance("int", "acl_rules", "resource_id","[resource_id]", 4, 10, 0, false, 0,false);
        $this->roleId =  CFW_FieldProperties_Abstract::newInstance("int", "acl_rules", "role_id","[role_id]", 4, 10, 0, false, 0,false);
        $this->allowCreate =  CFW_FieldProperties_Abstract::newInstance("int", "acl_rules", "allow_create","[allow_create]", 4, 10, 0, false, 0,false);
        $this->allowRead =  CFW_FieldProperties_Abstract::newInstance("int", "acl_rules", "allow_read","[allow_read]", 4, 10, 0, false, 0,false);
        $this->allowUpdate =  CFW_FieldProperties_Abstract::newInstance("int", "acl_rules", "allow_update","[allow_update]", 4, 10, 0, false, 0,false);
        $this->allowDelete =  CFW_FieldProperties_Abstract::newInstance("int", "acl_rules", "allow_delete","[allow_delete]", 4, 10, 0, false, 0,false);
        $this->description =  CFW_FieldProperties_Abstract::newInstance("varchar", "acl_rules", "description","[description]", 255, 0, 0, true, "",false);
        

        $this->entityClass = "CFW_Acl_Db_Models_Base_AclRulesTableRow";
         
    }

    /**
    * 全てのフィールドを列挙
    * 
    * @returns 
    */
    public function getFields()
    {
        $fields = array();
        $fields[] = $this->id;
        $fields[] = $this->resourceId;
        $fields[] = $this->roleId;
        $fields[] = $this->allowCreate;
        $fields[] = $this->allowRead;
        $fields[] = $this->allowUpdate;
        $fields[] = $this->allowDelete;
        $fields[] = $this->description;
        
        return $fields;
    }
    /**
    * 全ての主キーを列挙
    * 
    * @returns 
    */
    public function getPrimaryKeys()
    {
        $fields = array();
        $fields[] = $this->id;
        
        return $fields;
    }
    public function getUpdateFields(){
        $fields = array();
        if($this->id->doUpdate && !$this->id->isIdentity)$fields[] = $this->id;
        if($this->resourceId->doUpdate && !$this->resourceId->isIdentity)$fields[] = $this->resourceId;
        if($this->roleId->doUpdate && !$this->roleId->isIdentity)$fields[] = $this->roleId;
        if($this->allowCreate->doUpdate && !$this->allowCreate->isIdentity)$fields[] = $this->allowCreate;
        if($this->allowRead->doUpdate && !$this->allowRead->isIdentity)$fields[] = $this->allowRead;
        if($this->allowUpdate->doUpdate && !$this->allowUpdate->isIdentity)$fields[] = $this->allowUpdate;
        if($this->allowDelete->doUpdate && !$this->allowDelete->isIdentity)$fields[] = $this->allowDelete;
        if($this->description->doUpdate && !$this->description->isIdentity)$fields[] = $this->description;
        
        return $fields;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getName()
     */
    public function getName(){
        return $this->tableName;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setName($value)
     */
    public function setName($value){
        $this->talbeName = $value;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getAlias()
     */
    public function getAlias(){
        return $this->alias;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setAlias($value)
     */
    public function setAlias($value){
        $this->alias= $value;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setDoUpdate($doUpdate)
     */
    public function setDoUpdate($doUpdate = true){
        $this->id->doUpdate = $doUpdate;
        $this->resourceId->doUpdate = $doUpdate;
        $this->roleId->doUpdate = $doUpdate;
        $this->allowCreate->doUpdate = $doUpdate;
        $this->allowRead->doUpdate = $doUpdate;
        $this->allowUpdate->doUpdate = $doUpdate;
        $this->allowDelete->doUpdate = $doUpdate;
        $this->description->doUpdate = $doUpdate;
        
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getEntityClass()
     */
    public function getEntityClass(){
        return $this->entityClass;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getIdentityField()
     */
    public function getIdentityField(){
        return $this->identityField;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getCreatedAtField()
     */
    public function getCreatedAtField(){
        return $this->createdAtField;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getModifiedField()
     */
    public function getModifiedAtField(){
        return $this->modofiedAtField;
    }

    
}
