<?php
/**
 * このサンプルは動作しません。
 * @author okada
 *
 */
class Stack{
    var $sp;
    var $arr;
    
    public function __construct(){
        $this->sp = -1;
        $this->arr = array();
    }
    public function push($val){
        array_push( $this->arr[] ,$val);
        $this->sp++;   
    }
    public function pop(){
        $this->sp--;
        return array_pop($this->arr);
    }
    public function element($p){
        if($p < 0) return null;
        if($p > $this->sp) return null;
        
        return $this->arr($p);
    }
    public function last(){
        return $this->arr($this->sp);
    }
    public function pointer(){
        return $this->sp;
    }
    
}
class Element{
    var $token;
    var $val;
    
}
class Parser{
    /* terminal token*/
    const EL_BEGIN = 256;
    const EL_END = 257;
    const EL_NUM = 258;
    const EL_TERM_MAX = 258;
    /* non terminal token */
    const EL_EXPR = 259;
    
    const LT = 0;
    const EQ = 1;
    const GT = 2;
    const ERR = 3;
    /**
     * precedence table
     * @var unknown_type
     */
    var $prec_table;
    
    var $stack;
    var $result;
    
    function __construct(){
        $this->createPrecTable();
    }
    function tokenType($val){
        
    }
    function topmost_token_aux($p){
        $el = $stack->element($p);
        while($el->token > self::EL_TERM_MAX){
            $p--;
            $el = $stack->element($p);
        }
        return $p;
    }
    function topmost_token(){
        return $this->topmost_token_aux($stack->pointer() - 1);
    }
    function op_index(int $token) { /* 表を引きやすいように連続した数値に写す。*/
      switch (token) {
      case self::EL_BEGIN :  return 0;
      case '+':  return 1;
      case '*':  return 2;
      case '(':  return 3;
      case ')':  return 4;
      case self::EL_NUM :  return 5;
      case self::EL_END:  return 6;
      default:  echo sprintf("不正な構文要素 (%d)。\n", $token);
                return 0; 
      }
    }
    function createPrecTable(){
        
        $this->prec_table = array(
        
  /* 行に ENDがないこと、列に BGNがないことに注意。*/
          /* '+',  '*',  '(',  ')',  NUM, END */ 
  /* BGN */ array(self::LT,   self::LT,   self::LT,   self::ERR,  self::LT,  self::EQ),
  /* '+' */ array(self::GT,   self::LT,   self::LT,   self::GT,   self::LT,  self::GT),
  /* '*' */ array(self::GT,   self::GT,   self::LT,   self::GT,   self::LT,  self::GT),      
  /* '(' */ array(self::LT,   self::LT,   self::LT,   self::EQ,   self::LT,  self::ERR),
  /* ')' */ array(self::GT,   self::GT,   self::ERR,  self::GT,   self::ERR, self::GT),      
  /* NUM */ array(self::GT,   self::GT,   self::ERR,  self::GT,   self::ERR, self::GT)
        );      
    }
    /* 演算子順位表を利用する補助関数 */
    function prec($left, $right) {
      /* leftと rightの関係を表から引く。 */
      return $this->prec_table[$this->op_index($left)][$this->op_index($right)-1];
    }
    function handle_left() { /* 還元が起こる記号の列の左端を見つける */
        $next = null;
        $cur = $this->topmost_token(); /* スタックのトップの終端記号の位置 */
        $curel = $this->stack->element($cur);
        while (1) {
            $next = $this->topmost_token_aux(cur-1); /* 次の終端記号の位置 */
            $nextel = $this->stack->element($next);
            if ($this->prec($nextel->token, $curel->token) == self::LT) {
              return $next+1; /* nextの手前が求める場所 */
            } else { /* EQ */
              $cur = $next;
            }
        }
    }

    function reduce() {  /* 還元処理 */
        $leftp = $this->handle_left();   /* 還元する部分の左端を見つける */
        $left = $this->stack->element($leftp);
        
        $num = $this->stack->pointer - $leftp;          /* 還元する記号列の長さ */

        switch ($num) {                /* どの規則で還元するか? */
        case 1: {
            $data = $this->stack->pop();
            if ($data->token == self::EL_NUM) {
              /* Expr -> NUM */ 
              $this->stack->push(self::EL_EXPR, $data->val);        /* ポップしてすぐプッシュ */
              break;
            } else {
              echo sprintf("エラー: 不正なオペランド (%d)。\n", $data->token);
              exit(2);
            }
        }
        case 2: {
            $data2 = $this->stack->pop();
            $data1 = $this->stack->pop();
            echo sprintf("エラー: 不正な式 (%d, %d)。\n", $data1->token, $data2->token);
            exit(3);
        }
        case 3: {
            $data3 = $this->stack->pop();
            $data2 = $this->stack->pop();
            $data1 = $this->stack->pop();
            if ($data1->token == '(' && $data2->token == self::EL_EXPR && $data3->token == ')') {
                /* Expr -> '(' Expr ')' */
                $this->result = $data2->val;
                $this->stack->push(self::EL_EXPR,$this->result);
            } else if ($data1->token == self::EL_EXPR && $data2->token == '+' && $data3->token == self::EL_EXPR) {
                /* Expr -> Expr + Expr */
                /* printf("Expr -> Expr '+' Expr\n"); */
                $this->result = $data1->val + $data3->val;
                $this->stack->push(self::EL_EXPR, $this->result);
            } else if ($data1->token == self::EL_EXPR && $data2->token == '*' && $data3->token == self::EL_EXPR) {
                /* Expr -> Expr * Expr */
                /* printf("Expr -> Expr '*' Expr\n"); */
                $this->result = $data1->val * $data3->val;
                push(self::EL_EXPR, $this->result);
            } else {
                printf("エラー: 不正な式 (%d, %d, %d)。\n",
                $data1->token, $data2->token, $data3->token);
                exit(4);
            }
            break;
        }
        default:
            printf("構文エラー\n");
            exit(5);
        }
        return 0;
    }
    

    public function yyparse() {
        $pos = 0;
        $a = array(1,"1 + ");
        $tok = ""; 
        $top = null; 
        $relation = -1; /* 関係 */
        
        $this->stack->push(self::EL_BEGIN, 0 /* ダミー */); /* 始記号をスタックに積んでおく */
        $tok = yylex(); /* 最初のトークン */
        /* printf ("\ntoken=%d\n", tok); *//* デバッグ用 */
        while (1) {
            $topp = $this->topmost_token();  /* スタックのトップの終端記号 */
            $top = $this->stack->element($topp);
            
            if ($tok == $this->EL_END && $top->token == self::EL_BEGIN ) {
              return 0; /* 成功で終了 */
            }
            $relation = $this->prec($top->token, $tok);
            if ($relation == LT || $relation == EQ) {     /* シフト */
                /* printf("shift\n"); *//* デバッグ用 */
                $this->stack->push($tok, $this->result);
                $tok = yylex();    /* 次のトークンを読み込む */
                /* printf ("\ntoken=%d\n", tok); *//* デバッグ用 */
            } else if ($relation == GT) {                /* 還元 */
                if ($this->reduce()) { /* 0以外は構文エラー */
                    return 1;
                }
            } else { /* 表の空欄部分 --- エラー */
                echo sprintf("不正な構文要素 (%d)。\n", $tok);
                exit(6);
            }
        }
    }
    
}

?>