<?php
require_once 'startup.php';

$result = null;
$zip = "";
$pref = "";
$city = "";
    if(array_key_exists("zip",$_GET))  $zip = $_GET["zip"];
    if(array_key_exists("pref",$_GET))  $pref = $_GET["pref"];
    if(array_key_exists("city",$_GET)) $city = $_GET["city"];
    $result = search($zip,$pref,$city);
    
    echo Zend_Json::encode($result);



/**
 * 検索する。
 * 
 * TODO:limit,offset
 * @param $zip string 基本的にはこれを使う。
 * @param $pref string
 * @param $city string
 * @return 検索結果  array( "data" => array(),"count" => int )
 */
function search($zip,$pref = "",$city = "" ){
    
    if($zip == "" && $pref == "" && $city = ""){
        return array("data" => array(),"count" => 0);
    }
    $connection = CFW_Data_ConnectionFactory::getConnection("default");
    $connection->connect();
    
    $query = "select * from postaldata";
    $criteria = new CFW_Data_Criteria();
    if($zip != "" ){
        if(strlen($zip) == 7){
            $criteria->addWhereAnd(new CFW_Data_Criteria_ColumnValueCondition("zipcode7",$zip,CFW_Data_Criteria::OPERATOR_EQ));
        }
        else{
            $criteria->addWhereAnd(new CFW_Data_Criteria_ColumnValueCondition("zipcode7",$zip."%" ,CFW_Data_Criteria::OPERATOR_LIKE));
            
        }
    }
    if($pref != ""){
        $criteria->addWhereAnd(new CFW_Data_Criteria_ColumnValueCondition("pref",$pref."%" ,CFW_Data_Criteria::OPERATOR_LIKE));
    }    
    if($city != ""){
        $criteria->addWhereAnd(new CFW_Data_Criteria_ColumnValueCondition("city",$city."%" ,CFW_Data_Criteria::OPERATOR_LIKE));
    }
    $criteria->addOrderBy("id",CFW_Data_Criteria::DIRECTION_ASC);
    $criteria->setLimit(100); // 件数限定
    $criteria->assemble();    
    
    if ($criteria->getWhereExpression() != ""){
        $query .= " WHERE " . $criteria->getWhereExpression();
    }
    if ($criteria->getOrderByExpression() != ""){
        $query .= " ORDER BY " . $criteria->getOrderByExpression();
    }
    if ($criteria->getLimit() != 0){
        $query .= " LIMIT " . $criteria->getLimit();
    }
    
    $command = new CFW_Data_Command($query,$criteria->getParameters());
    
    $command->setConnection($connection);
    $queryResult = $command->executeQuery();
    
    $connection->disconnect();
    $result = array("data" => $queryResult,"count" => count($queryResult));
    return $result;

}

