<?php

ini_set('memory_limit', '128M');
ini_set('max_execution_time', 0);
print("start\n");

$dbname = "../data/postalcode.db3";

$filename = 'ken_all.csv';
$fileHandle = fopen($filename, "r");
$count = 0;

try{
    $dbh = new PDO("sqlite:".$dbname);
    
    createdb($dbh);
    createIndex($dbh);
    
    $dbh->beginTransaction();
    while (($data = fgetcsv($fileHandle, 4096, ",")) !== FALSE) {
    	if(count($data) < 3){
    		echo "invalid format";
    		break;
    	}
        insertRow($dbh,$data);
        $count++;
        if($count % 100 == 0) {echo ".";}
    }
    $dbh->commit();
    $dbh = null;
} catch (PDOException $e) {
    print "error : " . $e->getMessage() . "\n";
}


fclose($fileHandle);

print("\nprocessed : {$count}\n");

function insertRow($dbh,$params)
{
    
    $query = "INSERT INTO postaldata (
        code,
        zipcode5,
        zipcode7,
        pref_yomi,
        city_yomi,
        town_yomi,
        pref,
        city,
        town,
        special1,
        special2,
        special3,
        special4,
        update_flg,
        update_detail
    ) VALUES (
        '$params[0]',
        '$params[1]',
        '$params[2]',
        '$params[3]',
        '$params[4]',
        '$params[5]',
        '$params[6]',
        '$params[7]',
        '$params[8]',
        '$params[9]',
        '$params[10]',
        '$params[11]',
        '$params[12]',
        '$params[13]',
        '$params[14]'
    )";
    $sth = $dbh->prepare($query);
    $sth->execute();
        
}

function createdb($dbh)
{
    $query = "CREATE TABLE postaldata (
        id INTEGER NOT NULL PRIMARY KEY,
        code,
        zipcode5,
        zipcode7,
        pref_yomi,
        city_yomi,
        town_yomi,
        pref,
        city,
        town,
        special1,
        special2,
        special3,
        special4,
        update_flg,
        update_detail
        
    )";
    $dbh->exec($query);
}
function createIndex($dbh)
{
    $query = "CREATE INDEX ix_postaldata1 ON postaldata (code)";
    $dbh->exec($query);
    
    $query = "CREATE INDEX ix_postaldata2 ON postaldata (pref,city)";
    $dbh->exec($query);
}
