<?php
Zend_Loader::loadClass("CFW_Models_ITreeNode");

/**
 * TreeNode基本実装
 * @author okada
 * @package CFW_Models
 */
class CFW_Models_TreeNode implements CFW_Models_ITreeNode{
	/**
	 * 親ノード
	 * @var unknown_type
	 */
	var $parent;
	/**
	 * 子ノードのリスト
	 * @var unknown_type
	 */
	var $children = array();
	/**
	 * このノードを識別する名称
	 * @var unknown_type
	 */
	var $name;
	/**
	 * 追加データ
	 * @var unknown_type
	 */
	var $object;

	/**
	 * 構築.
	 * 識別名称を指定する
	 * @param unknown_type $name 識別名称.重複不可
	 * @return unknown_type
	 */
	public function __construct($name = ""){
		$this->name = $name;
	}
	/**
	 * (non-PHPdoc)
	 * @see library/CFW/Models/CFW_Models_ITreeNode#getName()
	 */
	public function getName(){
	    return $this->name;
	}
	/**
	 * (non-PHPdoc)
	 * @see library/CFW/Models/CFW_Models_ITreeNode#setName($name)
	 */
    public function setName($name){
        $this->name = $name;
    }
    /**
     * (non-PHPdoc)
     * @see library/CFW/Models/CFW_Models_ITreeNode#getParent()
     */
	public function getParent(){
	    return $this->parent;
	}
	/**
	 * (non-PHPdoc)
	 * @see library/CFW/Models/CFW_Models_ITreeNode#setParent($parent)
	 */
    public function setParent($parent){
        $this->parent = $parent;
    }
    /**
     * (non-PHPdoc)
     * @see library/CFW/Models/CFW_Models_ITreeNode#getChildren()
     */
    function getChildren(){return $this->children;}
    /**
     * (non-PHPdoc)
     * @see library/CFW/Models/CFW_Models_ITreeNode#setChildren($children)
     */
    function setChildren($children){$this->children = $children;}
    /**
     * (non-PHPdoc)
     * @see library/CFW/Models/CFW_Models_ITreeNode#getChild($name)
     */
    function getChild($name){return $this->children[$name];}
    /**
     * (non-PHPdoc)
     * @see library/CFW/Models/CFW_Models_ITreeNode#appendChild($node)
     */
	public function appendChild(CFW_Models_ITreeNode $node){
		$this->children[$node->getName()] = $node;
		$node->setParent($this);
	}
	/**
	 * (non-PHPdoc)
	 * @see library/CFW/Models/CFW_Models_ITreeNode#removeChilde($node)
	 */
	public function removeChilde(CFW_Models_ITreeNode $node){
		unset($this->children[$node->getName()]);
		$node->setParent(null);
	}
	/**
	 * このオブジェクトが指定ノードの先祖かどうか
	 * @param CFW_Models_ITreeNode $node
	 * @return unknown_type
	 */
	public function isAncestorOf(CFW_Models_ITreeNode $node){
		$result = false;
		$p = $node->getParent();
		while($p != null){
			if($this->getName()== $p->getName()){
				$result = true;
				break;
			}
			$p = $p->getParent();
		}
		return $result;
	}
	/**
	 * このオブジェクトが指定ノードの子孫かどうか
	 * @param CFW_Models_ITreeNode $node
	 * @return unknown_type
	 */
	public function isDescendantOf(CFW_Models_ITreeNode $node){
		return $node->isAncestorOf($this);
	}
	/* (non-PHPdoc)
	 * @see CFW/Model/CFW_Models_ITreeNode#pathString()
	 */
	public function pathString(){
		$path = $this->path();
		$result =join("/",$path);

		return $result;
	}

	/* (non-PHPdoc)
	 * @see CFW/Model/CFW_Models_ITreeNode#path()
	 */
	public function path(){
		$result = array($this->getName());

		$p = $this->getParent();
		while($p != null){
            if($p->getName() == "")break;
		    $result[] = $p->getName();
			$p = $p->getParent();
		}
		return array_reverse($result);
	}
	/* (non-PHPdoc)
	 * @see CFW/Model/CFW_Models_ITreeNode#find($path)
	 */
	public function find($path = array()){
		$target = null;
		$count = count($path);
		$current = $this;
		for($depth = 0;$depth < $count;$depth++){
			//現在のノードの子供に対象パスが見つかったらその子供を次のノードに設定する
			if(array_key_exists($path[$depth],$current->getChildren())){
				$current = $current->getChild($path[$depth]);
				//現在のノードを発見
				$target = $current;
				continue;
			}
			//見つからない
			break;
		}
		return $target;
	}
}