<?php
Zend_Loader::loadClass("CFW_Log_LoggerFactory");
Zend_Loader::loadClass("CFW_Util_Dump");
/**
 * エラーハンドラー(簡易)
 * <p>とりあえずログを出力する。それ以外は未定</p>
 * @author okada
 * @package CFW_Error
 */
class CFW_Error_Handler{
    /**
     * @var Exception
     */
    var $exception;
    var $file;
    var $class;
    var $function;

    var $errorId;

    /**
     * 
     * @var CFW_Auth_IUser
     */
    var $currentUser;
    
    /**
     * 構築
     * @param unknown_type $ex 発生した例外
     * @param unknown_type $file 発生元ファイル  basename(__FILE__)を使う。
     * @param unknown_type $class 発生元クラス。__CLASS__を使う。グローバル関数の場合空文字を使う。
     * @param unknown_type $func 発生元メソッド|関数。__FUNCTIONを使う。一見 クラス中のメソッドの場合__METHOD__のほうがよさそうだが、ログ出力した時にクラス名も分っているので冗長になる。
     * @param unknown_type $id 発生時のエラー追跡ID
     * @return unknown_type
     */
    public function __construct($ex,$file,$class,$func,$id){
        $this->exception = $ex;
        $this->file = $file;
        $this->class = $class;
        $this->function = $func;
        $this->errorId = $id;
        $this->currentUser = null;
    }
    /**
     * エラーを適切に処理？
     * <p>とりあえずログを書く。</p>
     * @param unknown_type $depth default 0 呼び出し履歴の深さ
     * @return unknown_type なし
     */
    public function handle($depth = 0){
        //logger生成
        $logger = $this->createLogger();

        $logger->error($this->function,"エラーが発生しました。#" . strval($this->errorId) ." " .$this->exception->getMessage(),$this->currentUser);
        $logger->error($this->function,"stack trace:".PHP_EOL.$this->exception->getTraceAsString(),$this->currentUser);
    }
    /**
     * ログ出力を生成
     * @return CFW_Log_Logger
     */
    private function createLogger(){
        $moduleName = "";
        if($this->class != ""){
            $moduleName = $this->class;
        }
        else{
            $moduleName = basename($this->file);
        }
        $logger = CFW_Log_LoggerFactory::getLogger("default",$moduleName);
        return $logger;
    }

}