<?php
Zend_Loader::loadClass("CFW_Data_DataSource");

/**
 * SQLサーバー用データソース.
 *
 * 主にlimit,offsetに対応する
 *
 * @author okada
 * @package CFW_Data_SqlServer
 */
class CFW_Data_SqlServer_DataSource extends CFW_Data_DataSource{
	
	/**
	 * 構築
	 * 
	 * @param CFW_Data_Connection $connection
	 * @param unknown_type $property
	 * @return unknown_type
	 */
	public function __construct($connection,$property = null){
		parent::__construct($connection,$property = null);	
	}
    /* (non-PHPdoc)
     * @see library/CFW/Data/CFW_Data_DataSource#buildSelectQuery($c, $fields)
     */
    public function buildSelectQuery(CFW_Data_Criteria $c,$fields){
            $query = "";
            $columns = "";
            $where =  "";
            $orderBy =  "";
            $groupBy =  "";
            $having =  "";
            $limits =  "";

            //columns 構築
            foreach($fields as $key => $field){
                if($columns != "") $columns .= ",";
                $columns .= $field . " AS " . $key;

            }
            if($c != null){
                //where句構築
                $where = $c->getWhereExpression();
                //orderBy構築
                $orderBy = $c->getOrderByExpression();
                //group by 構築
                $groupBy = $c->getGroupByExpression();
                //having構築
                $having = $c->getHavingExpression();
                //limit,offset
                if($c->getLimit() > 0){
                }
            }
            //limit,offset
            if($c->getLimit() > 0){
                $limit = $c->getLimit();
                $offset = $c->getOffset();
                $last = $offset + $limit;
                //最後の行まで
                $inner =  $this->buildInnserSelect($this->entityProperty->getName(),
                    $columns,
                    $where,
                    $groupBy,
                    $having,
                    $orderBy,
                    $last,
                    $c->queryOption);
                //裏返して件数分
                $outer =  $this->buildInnserSelect("(".$inner.") AS innerSelect",
                "","","","",$c->getOrderByReverseExpression(),
                $limit);
                //並びを元通りに
                $query =  $this->buildInnserSelect("(".$outer.") AS outerSelect",
                "","","","",$orderBy,
                0);
            }
            else{
                $query = $this->buildInnserSelect($this->entityProperty->getName(),$columns,$where,$groupBy,$having,$orderBy,0,$c->queryOption);

            }
            $this->selectQuery = $query;

    }
    /**
     * 選択クエリーの中身を作る
     * @param unknown_type $tableName
     * @param unknown_type $columns
     * @param unknown_type $where
     * @param unknown_type $groupBy
     * @param unknown_type $having
     * @param unknown_type $orderBy
     * @return string
     */
    function buildInnserSelect($tableName,$columns,$where,$groupBy,$having,$orderBy,$top = 0,$option = ""){
        $query = "SELECT";
        if($option != ""){
            $query .= " " . $option;
        }
        if($top > 0){
            $query .= " TOP " . strval($top);
        }
        if($columns == ""){
            $query .= " *";
        }
        else{
            $query .= " " . $columns;
        }
        //TODO:複数テーブル対応
        $query .= " FROM " . $tableName;
        if($where != ""){
            $query .= " WHERE " . $where;
        }
        if($groupBy != ""){
            $query .= " GROUP BY " . $groupBy;
        }
        if($having != ""){
            $query .= " HAVING " . $having;
        }
        if($orderBy != ""){
            $query .= " ORDER BY " . $orderBy;
        }
        return $query;
    }

}