<?php 
Zend_Loader::loadClass("CFW_Models_Entity");

/**
* table acl_roles Field定義
*/
class CFW_Acl_Db_Models_Base_AclRolesTableRow extends CFW_Models_Entity
{
    /** 
    * @var Number id [id]
    */
    public $id;
    /** 
    * @var String name [name]
    */
    public $name;
    /** 
    * @var Number leftSide [left_side]
    */
    public $leftSide;
    /** 
    * @var Number rightSide [right_side]
    */
    public $rightSide;
    /** 
    * @var String description [description]
    */
    public $description;
    /** 
    * @var Number deleted [deleted]
    */
    public $deleted;
    /** 
    * @var DateTime createdAt [created_at]
    */
    public $createdAt;
    /** 
    * @var DateTime modifiedAt [modified_at]
    */
    public $modifiedAt;
    
    /**
    * default construct 
    */
    public function __construct()
    {
        parent::__construct();
        $this->id = 0;
        $this->name = "";
        $this->leftSide = 0;
        $this->rightSide = 0;
        $this->description = "";
        $this->deleted = 0;
        $this->createdAt = null;
        $this->modifiedAt = null;
        
    }
    
    /**
    * 列名を指定して値を設定
    *
    * @param string name 列名
    * @param object value 値
    */
    public function setValue($name,$value)
    {
        if($name ==  "id") $this->id = CFW_Util_Number::numberValue( $value );
        if($name ==  "name") $this->name = CFW_Util_String::stringValue( $value );
        if($name ==  "left_side") $this->leftSide = CFW_Util_Number::numberValue( $value );
        if($name ==  "right_side") $this->rightSide = CFW_Util_Number::numberValue( $value );
        if($name ==  "description") $this->description = CFW_Util_String::stringValue( $value );
        if($name ==  "deleted") $this->deleted = CFW_Util_Number::numberValue( $value );
        if($name ==  "created_at") $this->createdAt = CFW_Util_Date::dateValue( $value );
        if($name ==  "modified_at") $this->modifiedAt = CFW_Util_Date::dateValue( $value );
        
    }
    /// <summary>
    /// 列名を指定して値を取得
    /// </summary>
    /// <param name="name">列名</param>
    /**
    * 列名を指定して値を取得
    *
    * @param string name 列名
    * @return object 値
    */
    public function getValue($name)
    {
        if($name ==  "id") return $this->id;
        if($name ==  "name") return $this->name;
        if($name ==  "left_side") return $this->leftSide;
        if($name ==  "right_side") return $this->rightSide;
        if($name ==  "description") return $this->description;
        if($name ==  "deleted") return $this->deleted;
        if($name ==  "created_at") return $this->createdAt;
        if($name ==  "modified_at") return $this->modifiedAt;
        
        return null;
    }
    
    /**
    * 指定データからのコピー
    * @param AclRolesTableRow コピー元
    * @return none
    */
    public function copyFrom($source)
    {
        $this->id = $source->id;
        $this->name = $source->name;
        $this->leftSide = $source->leftSide;
        $this->rightSide = $source->rightSide;
        $this->description = $source->description;
        $this->deleted = $source->deleted;
        $this->createdAt = $source->createdAt;
        $this->modifiedAt = $source->modifiedAt;
        
    }
}
