<?php

class Tokenizer{
    const EOF = false;
    var $reader;
    
    
    public function __construct($str){
        $this->reader = new StringReader($str);
    }
    public function hasMoreTokens(){
        return !$this->reader->isEOF();
    }
    public function nextToken(){
        if($this->reader->isEOF()){
            return self::EOF;
        }
        
        $inquote = false;
        $token = "";
        while(!$this->reader->isEOF()){
            $c = $this->reader->read();
            if($c == "("){
                if($token == ""){
                    $token = $c;
                }
                else{
                    $this->reader->pushBack($c);
                }
                break;
            }    
            if($c == ")"){
                if($token == ""){
                    $token = $c;
                }
                else{
                    $this->reader->pushBack($c);
                }
                break;
            }
            if($c == "\""){
                if($inquote){
                    $token .= $c;
                    break;
                }
                $inquote= true;
                $token .= $c;
                continue;
            }
            if($c == "\\"){
                $c2 = $this->reader->read();
                $token .= $c;
                $token .= $c2;
                
                continue;
            }
            if($c == "\r"){
                if($inquote){
                    $token .= $c;
                    continue;
                }
                $c2 = $this->reader->read();
                if($c2 == "\n"){
                    break;
                }
                else{
                    $this->reader->pushBack($c2);
                }
                
                continue;
            }
            if($c == "\n"){
                if($inquote){
                    $token .= $c;
                    continue;
                }
                break;
            }
            if(($c == " ") || ($c == "\t")){
                if($inquote){
                    $token .= $c;
                    continue;
                }
                if($token != ""){
                    break;
                }
                
                continue;
            }
            $token .= $c;
            
        }   
        return $token;
        
        
    }
    
}

class StringReader{
    const EOF = false;
    var $str;
    var $len;
    var $ptr;
    
    var $pushBacked;
    
    public function __construct($s){
        $this->str = $s;
        $this->len = mb_strlen($s);
        $this->ptr = 0;
        $this->pushBacked = array();
        
    }
    public function read(){
        if($this->ptr >= $this->len  ){
            return self::EOF;
        }
        
        if(count($this->pushBacked) > 0){
            $c = array_pop($this->pushBacked);
        }
        else{
            $c = mb_substr($this->str,$this->ptr,1);
        }
        $this->ptr++;
        return $c;
    }
    public function pushBack($c){
        array_push( $this->pushBacked , $c );
        $this->ptr--;
        
    }
    public function isEOF(){
        if($this->ptr >= $this->len  ){
            return true;
        }
        return false;
        
    }
    
}


$s = "";
$tokenizer = null;
if(isset($_POST["text"])){
    $tokenizer = new Tokenizer( $_POST["text"] );
    
}
else{
    
}



?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"> 
<title>tokenizer</title>
</head>
<body>
<div>
<form action="" method="post" >
<input type="text" name="text" id="text" value="<?php echo htmlspecialchars($s) ?>" size="100" /><br />
<input type="submit" name="submit" id="submit" value="send" />
</form>
<div id="result">
<?php if($tokenizer):?>
<?php while($tokenizer->hasMoreTokens()):?>
r=<?php echo htmlspecialchars($tokenizer->nextToken()) ?><br />
<?php endwhile;?>
<?php endif;?>
</div>
</div>
<script type="text/javascript">
//<![CDATA[
//]]>
</script>
</body>
</html>