<?php
require_once "../../startup.php";
Zend_Loader::loadClass("CFW_Data_ConnectionFactory");
Zend_Loader::loadClass("CFW_Data_Connection");
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_Html_Table");
Zend_Loader::loadClass("CFW_Data_SelectCommandBuilder");
Zend_Loader::loadClass("CFW_Data_Criteria");
Zend_Loader::loadClass("CFW_Data_Criteria_ColumnValueCondition");
Zend_Loader::loadClass("CFW_Sample_Models_MastSiteProperty");
Zend_Loader::loadClass("CFW_Sample_Models_MastMenuProperty");

$config = CFW_Config_Configuration::getInstance("connection")->connection;
$connection = new CFW_Data_Connection($config->default);
$connection->connect();

$select = new CFW_Data_SelectCommandBuilder("MAST_SITE","SITE");
$select->setOption("TOP 100");
$c = new CFW_Data_Criteria();
$c->addWhere(new CFW_Data_Criteria_StringCondition("SITE.SITE_CODE = MENU.SITE_CODE"));
$select->addJoin("MAST_MENU","MENU",$c);

$siteProperty = new CFW_Sample_Models_MastSiteProperty();
$siteProperty->setAlias("SITE");
$menuProperty= new CFW_Sample_Models_MastMenuProperty();
$menuProperty->setAlias("MENU");

$select->addField("SITE.SITE_CODE","SITE_CODE");
$select->addField("SITE.NAME","SITE_NAME");
$select->addField("count(*)","menu_count");

$criteria = new CFW_Data_Criteria();
$criteria->addOrderBy("count(*)","DESC");
$criteria->addGroupBy("SITE.SITE_CODE");
$criteria->addGroupBy("SITE.NAME");
$criteria->addHaving(new CFW_Data_Criteria_StringCondition("COUNT(*) > ?",array(new CFW_Data_Parameter("count",100))));
$select->setCriteria($criteria);

$select->buildCommand();
$command = $select->getCommand();
$command->setConnection($connection);
$result = $command->executeQuery();

$connection->disconnect();
?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="../../css/styles.css" />
</head>
<body>
<div class="searchResult">
<?php echo CFW_Html_Table::create("resultTable",
        array( array("headerText" => "site code","dataField" => "SITE_CODE"),
            array("headerText" => "site name","dataField" => "SITE_NAME"),
            array("headerText" => "count","dataField" => "menu_count")
            ),
        $result
    )
;?>
</div>

</body>
</html>