<?php
class Mini_Config{
	static $configs = array();
	
	var $data;
	
	public function __construct(){
		$this->data = array();
	}
	public static function load($name,$env = APPLICATION_ENV){
		if(array_key_exists($name,self::$configs)){
			return self::$config[$name];
		}
		
		$fileName = CONFIG_PATH."/".$name.".ini";
		$ini = parse_ini_file($fileName,true);
		
		$config = new Mini_Config();
		foreach($ini[$env] as $key => $value){
			$keyElements = explode(".",$key);
			$keyElementLength = count($keyElements);
			$configElement = $config;
			for($i = 0;$i < $keyElementLength - 1;$i++){
				$keyElement = $keyElements[$i];
				if($configElement->hasElement($keyElement)){
					$configElement = $configElement->$keyElement;
					continue;
				}
				$configElement->$keyElement = new Mini_Config();
				$configElement = $configElement->$keyElement;
				
			}
			$itemKey = $keyElements[$keyElementLength - 1];
			$configElement->$itemKey = $value;
		}
		self::$configs[$name] = $config;
		return $config;
	}
	public function __get($name){
		if(array_key_exists($name, $this->data)){
			return $this->data[$name];
		}
		return null;
	}
	public function __set($name,$value){
		$this->data[$name] = $value;
	}
	public function hasElement($name){
		return array_key_exists($name, $this->data);
		
	}
}