<?php
include_once("startup.php");
require_once 'PHPUnit/Framework.php';
Zend_Loader::loadClass("Zend_Config");
Zend_Loader::loadClass("CFW_Auth_Hash");
class HashTest extends PHPUnit_Framework_TestCase
{
    
    public function testMd5Valid(){
        $config = new Zend_Config(array(), true);
        $config->hashMethod = "MD5";
        $config->encode = "BASE64";
        $config->saltLength = 24;
        
        $input = "testtest";
        $checkValue = "testtest";
        
        $hash = CFW_Auth_Hash::getInstance($config->hashMethod = "MD5");
        $hash->config = $config;
        
        $hashedValue = $hash->createHash($input);
        $result = $hash->verify($checkValue,$hashedValue);
        $this->assertTrue($result);

    }
    public function testMd5Invalid(){
        $config = new Zend_Config(array(), true);
        $config->hashMethod = "MD5";
        $config->encode = "BASE64";
        $config->saltLength = 24;
        
        $input = "testtest";
        $checkValue = "testtes";
        
        $hash = CFW_Auth_Hash::getInstance($config->hashMethod = "MD5");
        $hash->config = $config;
        
        $hashedValue = $hash->createHash($input);
        $result = $hash->verify($checkValue,$hashedValue);
        $this->assertFalse($result);
    }
    public function testSha1Valid(){
        $config = new Zend_Config(array(), true);
        $config->hashMethod = "SHA1";
        $config->encode = "BASE64";
        $config->saltLength = 24;
        
        $input = "testtest";
        $checkValue = "testtest";
        
        $hash = CFW_Auth_Hash::getInstance($config->hashMethod = "MD5");
        $hash->config = $config;
        
        $hashedValue = $hash->createHash($input);
        $result = $hash->verify($checkValue,$hashedValue);
        $this->assertTrue($result);
    }
    public function testSha1Invalid(){
        $config = new Zend_Config(array(), true);
        $config->hashMethod = "SHA1";
        $config->encode = "BASE64";
        $config->saltLength = 24;
        
        $input = "testtest";
        $checkValue = "testtes";
        
        $hash = CFW_Auth_Hash::getInstance($config->hashMethod = "MD5");
        $hash->config = $config;
        
        $hashedValue = $hash->createHash($input);
        $result = $hash->verify($checkValue,$hashedValue);
        $this->assertFalse($result);
    }
    public function testSsha1Valid(){
        $config = new Zend_Config(array(), true);
        $config->hashMethod = "SSHA1";
        $config->encode = "BASE64";
        $config->saltLength = 24;
        
        $input = "testtest";
        $checkValue = "testtest";
        
        $hash = CFW_Auth_Hash::getInstance($config->hashMethod = "MD5");
        $hash->config = $config;
        
        $hashedValue = $hash->createHash($input);
        $result = $hash->verify($checkValue,$hashedValue);
        $this->assertTrue($result);
    }
    public function testSsha1Invalid(){
        $config = new Zend_Config(array(), true);
        $config->hashMethod = "SSHA1";
        $config->encode = "BASE64";
        $config->saltLength = 24;
        
        $input = "testtest";
        $checkValue = "testtes";
        
        $hash = CFW_Auth_Hash::getInstance($config->hashMethod = "MD5");
        $hash->config = $config;
        
        $hashedValue = $hash->createHash($input);
        $result = $hash->verify($checkValue,$hashedValue);
        $this->assertFalse($result);
    }
    public function testSmd5Valid(){
        $config = new Zend_Config(array(), true);
        $config->hashMethod = "SMD5";
        $config->encode = "BASE64";
        $config->saltLength = 24;
        
        $input = "testtest";
        $checkValue = "testtest";
        
        $hash = CFW_Auth_Hash::getInstance($config->hashMethod = "MD5");
        $hash->config = $config;
        
        $hashedValue = $hash->createHash($input);
        $result = $hash->verify($checkValue,$hashedValue);
        $this->assertTrue($result);
    }
    public function testSmd5Invalid(){
        $config = new Zend_Config(array(), true);
        $config->hashMethod = "SMD5";
        $config->encode = "BASE64";
        $config->saltLength = 24;
        
        $input = "testtest";
        $checkValue = "testtes";
        
        $hash = CFW_Auth_Hash::getInstance($config->hashMethod = "MD5");
        $hash->config = $config;
        
        $hashedValue = $hash->createHash($input);
        $result = $hash->verify($checkValue,$hashedValue);
        $this->assertFalse($result);
    }
    
}