<?php
Zend_Loader::loadClass("CFW_FieldProperties_Int");
Zend_Loader::loadClass("CFW_FieldProperties_Long");
Zend_Loader::loadClass("CFW_FieldProperties_Byte");
Zend_Loader::loadClass("CFW_FieldProperties_Short");
Zend_Loader::loadClass("CFW_FieldProperties_String");
Zend_Loader::loadClass("CFW_FieldProperties_Decimal");
Zend_Loader::loadClass("CFW_FieldProperties_Double");
Zend_Loader::loadClass("CFW_FieldProperties_Date");
Zend_Loader::loadClass("CFW_Constants_Number");
Zend_Loader::loadClass("CFW_Constants_DateTime");

/**
 * フィールドプロパティの基本
 * @author okada
 * @package CFW_FieldProperties
 */
abstract class CFW_FieldProperties_Abstract{
	/**
	 * 元になるテーブル名称
	 * @var string
	 */
	public $tableName;
	public $tableAlias;
	/**
	 * 元になる列名
	 * @var string
	 */
    public $fieldName;
    /**
     * タイプ
     * @var string
     */
    public $fieldType;
    /**
     * 長さ
     * @var integer
     */
    public $length;
    /**
     * 有効長
     * @var integer
     */
    public $precision;
    /**
     * 精度
     * @var integer
     */
    public $scale;
    /**
     * NULL許可
     * @var boolean
     */
    public $nullable;
    /**
     * primary key
     * @var boolean
     */
    public $isPrimaryKey;
    /**
     * identity
     * @var boolean
     */
    public $isIdentity;
    /**
     * 説明
     * @var string
     */
    public $description;
    /**
     * 元になるテーブル列に定義された型の名前
     * @var string
     */
    public $sqlTypeName;
    /**
     * 表示用の名称
     * TODO：ここにに持つべきか
     * @var string
     */
    public $displayName;
    /**
     * 更新対象列
     * @var boolean
     */
	public $doUpdate;
	/**
	 * 入力フォーマット
	 * @var string
	 */
    public $format;
    /**
     * 表示用フォーマット
     * #0,yyyy/MM/dd,etc...
     * @var string
     */
    public $displayFormat;
    /**
     * DB上でのフォーマット
     * 保存の都合上varcharなどで定義してある別のタイプの項目が保存されるときに適用されるフォーマット
     * yyyyMMdd etc...
     * @var string
     */
    public $dbFormat;
    /**
     * default
     * @var object
     */
    public $defaultValue;
    /**
     * 数値型の場合の0値の扱い
     * @var boolean
     */
    public $allowZero;
    /**
     * 検証回避対象
     * @var boolean
     */
    public $ignoreValidation;

    /**
     * 構築
     * @param array $spec
     * @return
     */
    public function __construct($spec = null){
    	if ($spec == null) return;
    	$this->tableName = $spec["tableName"];
    	$this->tableAlias = "";
    	$this->fieldName = $spec["fieldName"];
    	$this->fieldType = $spec["fieldType"];
    	$this->length = $spec["length"];
    	$this->precision = $spec["precision"];
    	$this->scale = $spec["scale"];
    	$this->nullable = $spec["nullable"];
    	$this->defaultValue = $spec["defaultValue"];
    	$this->isPrimaryKey = $spec["isPrimaryKey"];
    	$this->isIdentity = $spec["isIdentity"];
    	$this->displayName = $spec["displayName"];
    	$this->sqlTypeName = $spec["sqlTypeName"];
    	$this->description = $spec["description"];
    	$this->format = $spec["format"];
    	$this->displayFormat = $spec["displayFormat"];
    	$this->dbFormat = $spec["dbFormat"];
    	$this->doUpdate = true;
    	$this->allowZero = false;
    	$this->ignoreValidation = false;
    }

    public static function newInstance(
	   	$sqlTypeName,
	   	$tableName,
	   	$columnName,
	   	$displayName,
	   	$length,
	   	$prec,
	   	$scale,
	   	$nullable = true,
	   	$columnDef = null,
	   	$isPrimaryKey = false,
	   	$isIdentity = false
   	){
   		$spec["sqlTypeName"] = $sqlTypeName;
   		$spec["tableName"] = $tableName;
   		$spec["fieldName"] = $columnName;
   		$spec["displayName"] = $displayName;
   		$spec["length"] = $length;
   		$spec["precision"] = $prec;
   		$spec["scale"] = $scale;
   		$spec["nullable"] = $nullable;
   		$spec["defaultValue"] = $columnDef;
   		$spec["isPrimaryKey"] = $isPrimaryKey;
   		$spec["isIdentity"] = $isIdentity;
   		$spec["description"] = "";
   		$spec["format"] = "";
   		$spec["displayFormat"] = "";
   		$spec["dbFormat"] = "";
   		$spec["fieldType"] = "";

   		return self::createBySpec($spec);
   	}

   	private static function createBySpec($spec){
   		$sqlTypeName = mb_strtolower($spec["sqlTypeName"]);
   		if ($sqlTypeName == "int") {
   			$fieldProperty= new CFW_FieldProperties_Int($spec);
   			$fieldProperty->fieldType = "int";
   			return $fieldProperty;
   		}
   		if ($sqlTypeName == "bigint") {
   			$fieldProperty = new CFW_FieldProperties_Long($spec);
   			$fieldProperty->fieldType = "long";
   			return $fieldProperty;
   		}
   		if ($sqlTypeName == "tinyint") {
   			$fieldProperty->fieldType = "byte";
   			$fieldProperty = new CFW_FieldProperties_Byte($spec);
   			return $fieldProperty;
   		}
   		if ($sqlTypeName == "smallint") {
   			$fieldProperty = new CFW_FieldProperties_Short($spec);
   			$fieldProperty->fieldType = "short";
   			$fieldProperty->minValue = CFW_Constants_Number::INT16_MIN;
   			$fieldProperty->maxValue = CFW_Constants_Number::INT16_MAX;
   			return $fieldProperty;
   		}
        if ($sqlTypeName == "varchar" || $sqlTypeName == "char"  || $sqlTypeName == "text") {
            $fieldProperty = new CFW_FieldProperties_String($spec);
            $fieldProperty->fieldType = "string";
            $fieldProperty->useWideChar = false;
            return $fieldProperty;
        }
        if ($sqlTypeName == "nvarchar" || $sqlTypeName == "nchar"  || $sqlTypeName == "ntext") {
            $fieldProperty = new CFW_FieldProperties_String($spec);
            $fieldProperty->fieldType = "string";
            $fieldProperty->useWideChar = true;

            return $fieldProperty;
        }

   		if ($sqlTypeName == "decimal") {
   			$fieldProperty = new CFW_FieldProperties_Decimal($spec);
   			$fieldProperty->fieldType = "decimal";
   			return $fieldProperty;
   		}
   		if ($sqlTypeName == "money") {
   			$fieldProperty = new CFW_FieldProperties_Decimal($spec);
   			$fieldProperty->fieldType = "decimal";
   			$fieldProperty->precision = 19;
   			$fieldProperty->scale = 4;
   			$fieldProperty->length = 21;
   			return $fieldProperty;
   		}
   		//SQLServer: real = 単精度 float = 倍制度,,,SQL92では単精度がfloatなので判別付かない。
   		//とりあえずdoubleFieldPropertyを使って代用
   		if ($sqlTypeName == "float" || $sqlTypeName == "double") {
   			$fieldProperty = new CFW_FieldProperties_Double($spec);
   			$fieldProperty->fieldType = "double";
   			return $fieldProperty;
   		}
   		if ($sqlTypeName == "datetime") {
   			$fieldProperty = new CFW_FieldProperties_Date($spec);
   			$fieldProperty->fieldType = "datetime";
   			$fieldProperty->minValue = new Date("17530101");
   			$fieldProperty->maxValue = new Date("99991231");
   			return $fieldProperty;
   		}
   		if ($sqlTypeName == "smalldatetime") {
   			$fieldProperty = new CFW_FieldProperties_Date($spec);
   			$fieldProperty->fieldType = "datetime";
   			$fieldProperty->minValue = new Date("19000101");
   			$fieldProperty->maxValue = new Date("20790606");
   			return $fieldProperty;
   		}
   		return null;
   	}

   	/**
   	 * この列のフル名称
   	 * @param string $tableAlias テーブルに付ける別名
   	 * @return string
   	 */
   	public function fullName(){
   	    $tn = "";
   	    if($this->tableAlias != ""){
   	        $tn = $this->tableAlias;
   	    }
   	    else{
       	    $tn = $this->tableName;
   	    }
   		return "\"".$tn."\"" ."."."\"".$this->fieldName."\"";
   	}

   	/**
   	 * この列の別名
   	 * @param string $tableAlias テーブルに付ける別名
   	 * @return string
   	 */
   	public function alias(){
   	    $tn = "";
   	    if($this->tableAlias != ""){
   	        $tn = $this->tableAlias;
   	    }
   	    else{
       	    $tn = $this->tableName;
   	    }
   	    return $tn."__".$this->fieldName;
   	}
}