<?php
Zend_Loader::loadClass("Zend_Auth_Result");
Zend_Loader::loadClass("Zend_Amf_Auth_Abstract");
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_Log_LoggerFactory");
Zend_Loader::loadClass("CFW_Amf_AppKey");

/**
 * AMF認証
 *
 * AMF呼び出しの基本的な認証を行う。
 *
 * AIRアプリケーション作成時に使用システム単位にID,パスワードを作成し、クライアント側、サーバー側に設定する。設定内容は以下
 *
 * サーバー側
 * <code>
 * amf.appauth.user = amfuser
 * amf.appauth.password = amfpass
 * </code>
 *
 * クライアント側
 * <code>
 * <remoteObject name="default" destination="amfservice"  user="amfuser" password="amfpass" />
 * </code>
 *
 * @author okada
 * @package CFW_Amf
 */
class CFW_Amf_Auth extends  Zend_Amf_Auth_Abstract{
    var $logger;

    public function __construct(){
        //parent::__construct();
        $this->logger = CFW_Log_LoggerFactory::getLogger("default",__CLASS__);
        $this->logger->debug(__FUNCTION__,"construct");
    }
    /**
     * 認証を試みます.
     *
     * <p>とりあえず、ユーザー/パスワードをcore.iniに書いておき認証処理にする。この値は使用する案件ごとに設定する事。</p>
     * @throws Zend_Auth_Adapter_Exception が、認証処理をできなかった場合に発生します
     * @return Zend_Auth_Result
     */
    public function authenticate()
    {
        $this->logger->debug(__FUNCTION__,"authenticate by " . $this->_username);

        $appkey = new CFW_Amf_AppKey();
        $valid = $appkey->validate($this->_username,$this->_password);
        if($valid){
            $result = new Zend_Auth_Result(Zend_Auth_Result::SUCCESS,$this->_username,array());
            return $result;
        }
        $result = new Zend_Auth_Result(Zend_Auth_Result::FAILURE,null,array("使用できません。")); //TODO: メッセージはmessageResourceから
        return $result;
    }
}