<?php
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_Log_Logger");
/**
 * Logger生成クラス.
 *
 * 出力先名称と使用モジュール名から対応するLoggerを生成する。
 * @author okada
 * @package CFW_Log
 */
class CFW_Log_LoggerFactory{
    /**
     * Loggerを生成する
     * @param String $name ログ出力先の名前
     * @param String $module ログを使うモジュールの名前
     * @return CFW_Log_Logger 設定に基づくログ出力
     */
    public static function getLogger($name,$module){
        $config = CFW_Config_Configuration::getInstance("core");
        /* @var Zend_Config */
        $logConfig = $config->log->get($name);
        //設定されて無いならdefaultに出力する。余計なものを混ぜないためにはちゃんと設定すること
        if($logConfig == null) $logConfig = $config->log->get("default");
        $logger = new CFW_Log_Logger();
        //writerを構築する
        $writer = null;
        if($logConfig != null){
	        $writerClassName = $logConfig->writer;
	        Zend_Loader::loadClass($writerClassName);
	        $writer = new $writerClassName();
	        $writer->init($logConfig);
        	$logger->writer = $writer;
	        $logger->logLevel = $logConfig->priority;
        }
        //loggerを構築する
        $logger->moduleName = $module;

        return $logger;
    }
    static function resolveName($name,$date){
        $n = str_replace("%Y",date("Y",$date),$name);
        $n = str_replace("%m",date("m",$date),$n);
        $n = str_replace("%d",date("d",$date),$n);

        return $n;
    }

}