<?php
/**
 * 良く使う正規表現
 * @author okada
 * @param CFW_Constants
 */
class CFW_Constants_Regex{
    /*
     * 日付+時刻
     */
    const DATETIME_LONG = "^\d{4}[/\-]([0]?\d|1[0-2])[/\-]([0-2]?[0-9]|3[0-1]) +([01]?[0-9]|2[0-3]):[0-5]?[0-9]:[0-5]?[0-9]$";
    /*
     * 日付+時刻
     */
    const DATETIME_SMALL = "^\d{4}[/\-]([0]?\d|1[0-2])[/\-]([0-2]?[0-9]|3[0-1]) +([01]?[0-9]|2[0-3]):[0-5]?[0-9]$";
    /*
     * 日付  2005/11/1 2005/1/1 2005/02/03 05/01/01  NG：2005/01 2005/1/32
     */
    const DATE_LONG = "^\d{4}[/\-]([0]?\d|1[0-2])[/\-]([0-2]?[0-9]|3[0-1])$";
    /*
     * 短い日付
     */
    const DATE_SHORT = "^\d{2}[/\-]([0]?\d|1[0-2])[/\-]([0-2]?[0-9]|3[0-1])$";
    /*
     * 日付+時刻 区切りなし
     */
    const DATETIME_LONG_NO_DELIMITER = "^\d{4}([0]\d|1[0-2])([0-2]\d|3[0-1])([01][0-9]|2[0-3])[0-5][0-9][0-5][0-9]$";
    /*
     * 日付+時刻 区切りなし
     */
    const DATETIME_SMALL_NO_DELIMITER = "^\d{4}([0]\d|1[0-2])([0-2]\d|3[0-1])([01]\d|2[0-3])[0-5]\d$";
    /*
     * 長い日付 区切りなし
     */
    const DATE_LONG_NO_DELIMITER = "^\d{4}(0[0-9]|1[012])([012][0-9]|3[01])$";
    /*
     * 短い日付 区切りなし
     */
    const DATE_SHORT_NO_DELIMITER = "^\d{2}(0[0-9]|1[0-2])([012][0-9]|3[01])$";
}