<?php
Zend_Loader::loadClass("Zend_Config_Ini");
/**
 * Zend_Configのショートカットクラス.
 *
 * 定数 "APPLICATION_ENV"が定義されているときは読み込むセクションのデフォルトに使用する。
 * そうでなければ"production"を読み込むセクションのデフォルトに使用する。
 *
 * @author okada
 * @package CFW_Config
 */
class CFW_Config_Configuration{

	/**
	 * 設定オブジェクトを取得.
	 * @param $name 設定種別名
	 * @param $env 環境名 指定されなければ定数"ENV"の設定を、定数"ENV"が設定されていなければ"production"をデフォルトにする
	 * @return Zend_Config
	 */
	public static function getInstance($name = "core",$env = null){
		if(!$env){
			if(defined("APPLICATION_ENV")){
				$env = APPLICATION_ENV;
			}
			else{
				$env = "production";
			}
		}

		$config = new Zend_Config_Ini(CONFIG_PATH.'/'.$name.'.ini',$env);
		return $config;
	}
}