<?php 
Zend_Loader::loadClass("CFW_Models_Entity");

/**
* table acl_rules Field定義
*/
class CFW_Acl_Db_Models_Base_AclRulesTableRow extends CFW_Models_Entity
{
    /** 
    * @var Number id [id]
    */
    public $id;
    /** 
    * @var Number resourceId [resource_id]
    */
    public $resourceId;
    /** 
    * @var Number roleId [role_id]
    */
    public $roleId;
    /** 
    * @var Number allowCreate [allow_create]
    */
    public $allowCreate;
    /** 
    * @var Number allowRead [allow_read]
    */
    public $allowRead;
    /** 
    * @var Number allowUpdate [allow_update]
    */
    public $allowUpdate;
    /** 
    * @var Number allowDelete [allow_delete]
    */
    public $allowDelete;
    /** 
    * @var String description [description]
    */
    public $description;
    
    /**
    * default construct 
    */
    public function __construct()
    {
        parent::__construct();
        $this->id = 0;
        $this->resourceId = 0;
        $this->roleId = 0;
        $this->allowCreate = 0;
        $this->allowRead = 0;
        $this->allowUpdate = 0;
        $this->allowDelete = 0;
        $this->description = "";
        
    }
    
    /**
    * 列名を指定して値を設定
    *
    * @param string name 列名
    * @param object value 値
    */
    public function setValue($name,$value)
    {
        if($name ==  "id") $this->id = CFW_Util_Number::numberValue( $value );
        if($name ==  "resource_id") $this->resourceId = CFW_Util_Number::numberValue( $value );
        if($name ==  "role_id") $this->roleId = CFW_Util_Number::numberValue( $value );
        if($name ==  "allow_create") $this->allowCreate = CFW_Util_Number::numberValue( $value );
        if($name ==  "allow_read") $this->allowRead = CFW_Util_Number::numberValue( $value );
        if($name ==  "allow_update") $this->allowUpdate = CFW_Util_Number::numberValue( $value );
        if($name ==  "allow_delete") $this->allowDelete = CFW_Util_Number::numberValue( $value );
        if($name ==  "description") $this->description = CFW_Util_String::stringValue( $value );
        
    }
    /// <summary>
    /// 列名を指定して値を取得
    /// </summary>
    /// <param name="name">列名</param>
    /**
    * 列名を指定して値を取得
    *
    * @param string name 列名
    * @return object 値
    */
    public function getValue($name)
    {
        if($name ==  "id") return $this->id;
        if($name ==  "resource_id") return $this->resourceId;
        if($name ==  "role_id") return $this->roleId;
        if($name ==  "allow_create") return $this->allowCreate;
        if($name ==  "allow_read") return $this->allowRead;
        if($name ==  "allow_update") return $this->allowUpdate;
        if($name ==  "allow_delete") return $this->allowDelete;
        if($name ==  "description") return $this->description;
        
        return null;
    }
    
    /**
    * 指定データからのコピー
    * @param AclRulesTableRow コピー元
    * @return none
    */
    public function copyFrom($source)
    {
        $this->id = $source->id;
        $this->resourceId = $source->resourceId;
        $this->roleId = $source->roleId;
        $this->allowCreate = $source->allowCreate;
        $this->allowRead = $source->allowRead;
        $this->allowUpdate = $source->allowUpdate;
        $this->allowDelete = $source->allowDelete;
        $this->description = $source->description;
        
    }
}
