<?php
require_once "../../startup.php";
Zend_Loader::loadClass("CFW_Acl_AccessControl");
Zend_Loader::loadClass("CFW_Acl_Rule");
Zend_Loader::loadClass("CFW_Acl_Resource");
Zend_Loader::loadClass("CFW_Acl_Role");
Zend_Loader::loadClass("CFW_Util_StopWatch");

$acl = new CFW_Acl_AccessControl();
$acl->addRole("admin");
$acl->addRole("members");
$acl->addRole("anonymous");

$acl->addRole("members1","members");
$acl->addRole("members2","members");
$acl->addRole("members3","members");
$acl->addRole("members4","members");

$acl->addRole("members1-1","members1");
$acl->addRole("members1-2","members1");
$acl->addRole("members1-3","members1");
$acl->addRole("members1-4","members1");

$acl->addRole("members3-1","members3");
$acl->addRole("members3-2","members3");
$acl->addRole("members3-3","members3");
$acl->addRole("members3-4","members3");

$acl->addResource("resource1");
$acl->addResource("resource2");
$acl->addResource("resource3");
$acl->addResource("resource4");

$acl->addResource("resource2-1", "resource2");
$acl->addResource("resource2-2", "resource2");
$acl->addResource("resource2-3", "resource2");
$acl->addResource("resource2-4", "resource2");

$acl->addResource("resource4-1", "resource4");
$acl->addResource("resource4-2", "resource4");
$acl->addResource("resource4-3", "resource4");
$acl->addResource("resource4-4", "resource4");

$acl->addRule("resource1","members1",CFW_Acl_Privilege::READ);
$acl->addRule("resource2-1","members1",CFW_Acl_Privilege::CREATE);
$acl->addRule("resource2-1","members2",CFW_Acl_Privilege::UPDATE);
$acl->addRule("resource3","members3",CFW_Acl_Privilege::ALL);
$acl->addRule("resource3","members3-1",CFW_Acl_Privilege::DELETE);

$role1 = $acl->findRole("members1");
$role1_1= $acl->findRole("members1-1");
$role1_2= $acl->findRole("members1-2");
$role1_3= $acl->findRole("members1-3");
$role1_4= $acl->findRole("members1-4");

$role2= $acl->findRole("members2");
$role3= $acl->findRole("members3");
$role3_1= $acl->findRole("members3-1");
$role3_2= $acl->findRole("members3-2");
$role3_3= $acl->findRole("members3-3");
$role3_4= $acl->findRole("members3-4");
$role4= $acl->findRole("members4");

function renderNode($node){
    echo "<li>{$node->getName()}</li>";
    $children = $node->getChildren();
    foreach($children as $child){
        echo "<ul>";
        renderNode($child);
        echo "</ul>";
    }
}
?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>
<body>
<div>
<ul><?php renderNode($acl->resources)?>
</ul>
<ul><?php renderNode($acl->roles)?>
</ul>
</div>
<div class="searchResult">
<div>resource1 - role1 <?php echo $acl->isAllowed("resource1",CFW_Acl_Privilege::READ,array($role1)) ? "true":"false"; ?>許可</div>
<div>resource1 - role1-1 <?php echo $acl->isAllowed("resource1",CFW_Acl_Privilege::READ,array($role1_1)) ? "true":"false";  ?>許可</div>
<div>resource1 - role2 <?php echo $acl->isAllowed("resource1",CFW_Acl_Privilege::READ,array($role2)) ? "true":"false";  ?>拒否</div>
<div>resource2 - role1 <?php echo $acl->isAllowed("resource2",CFW_Acl_Privilege::READ,array($role1))  ? "true":"false"; ?>拒否</div>
<div>resource2 - role2 <?php echo $acl->isAllowed("resource2",CFW_Acl_Privilege::READ,array($role2))  ? "true":"false"; ?>拒否</div>
<div>resource2-1 - role1 <?php echo $acl->isAllowed("resource2-1",CFW_Acl_Privilege::READ,array($role1))  ? "true":"false"; ?>拒否</div>
<div>resource2-1 - role1-1 <?php echo $acl->isAllowed("resource2-1",CFW_Acl_Privilege::CREATE,array($role1_1))  ? "true":"false"; ?>l許可</div>
</div>


</body>
</html>