<?php
/**
 * HTML用便利メソッド.
 * @see CFW_Html_Util
 * @author okada
 * @package CFW_Util
 */
class CFW_Util_Html{
	/**
	 * 入力文字列をエスケープする。
	 * 引用符、<>,などを実体参照にする。
	 * @param unknown_type $s
	 * @param unknown_type $encoding 指定なしの場合システムのデフォルトエンコーディングを使う
	 * @return string エスケープ結果
	 */
	public static function escape($s,$encoding = null){
	    if(is_string($s)){
    		if($encoding === null) $encoding = mb_internal_encoding();
    		return htmlspecialchars($s,ENT_QUOTES,$encoding);
	    }
	    else{
	        return strval($s);
	    }
	}
}