<?php
class CFW_Ldap_Criteria_Expression extends CFW_Ldap_Criteria_AbstractExpression{
    var $terms;
    var $modifier;
    
    public function __construct(){
        $this->terms= array();
    }
    public function parse(ArrayIterator &$iterator){
        $element = $iterator->current();

        $term = new CFW_Ldap_Criteria_Term();
        $this->terms[] = $term->parse($iterator);                
    
        while(true){
            if(!$iterator->valid()) break;
            
            $element = $iterator->current();
            if($element instanceof CFW_Ldap_Criteria_OperatorElement){
                if($element->op !== CFW_Ldap_Criteria::CRITERIA_OR){
                    break;
                }
                
                $iterator->next();
                if(!$iterator->valid()) break;
            }
            $element = $iterator->current();
            $term = new CFW_Ldap_Criteria_Term();
            $this->terms[] = $term->parse($iterator);                

        }
        
        return $this;
        
    }
    public function getExpression(){
        if(count($this->terms) == 1){
            $term = $this->terms[0];
            if($this->modifier != ""){
                return "(". $this->modifier . "(".  $term->getExpression() . "))";
                
            }
            else{
                return  $term->getExpression() ;
            }
            
        }
        else if(count($this->terms) > 1){
            $s = "|";
            foreach($this->terms as $term){
                $s .=  $term->getExpression() ;
            }
            if($this->modifier != ""){
                return "(". $this->modifier . "(" . $s ."))";
                
            }
            else{
                return "(" . $s .")";
            }
            
        }
        
        
    }
    public function dump(){
        if(count($this->terms) == 1){
            $term = $this->terms[0];
            if($this->modifier != ""){
                return "(". $this->modifier . "(".  $term->dump() . "))";
                
            }
            else{
                return  $term->dump() ;
            }
            
        }
        else if(count($this->terms) > 1){
            $s = "|";
            foreach($this->terms as $term){
                $s .=  $term->dump() ;
            }
            if($this->modifier != ""){
                return "(". $this->modifier . "(" . $s ."))";
                
            }
            else{
                return "(" . $s .")";
            }
            
        }
        
    }
}

?>