<?php
include( "../core.php" );

/**
 * 再帰下降型
 * Tokenizerを使う
 * 結果をExpressionオブジェクトのかたまりにする
 *
 * BNF
 * Expr = Term { + Term }
 * Term = Fact { * Fact }
 * Fact = ( Expr ) | number
 * @author okada
 */


/**
 * 足し算
 * @author okada
 *
 */
class Expression{
    var $terms;

    public function __construct(){
        $this->terms = array();
    }
    function dump(){
        $s = "";
        foreach($this->terms as $term){
            if($s != "") $s .= " + "; 
            $s .= $term->dump();
        }
        return  " t( " . $s  . " ) ";
    }
}
/**
 * 掛け算
 * @author okada
 *
 */
class Term{
    var $facts;

    public function __construct(){
        $this->facts = array();
    }
    function dump(){
        $s = "";
        foreach($this->facts as $fact){
            if($s != "") $s .= " * "; 
            $s .= $fact->dump();
        }
        return " f( " . $s . " ) ";
    }
}
class Fact{
    var $expr;
    function dump(){
        return  $this->expr->dump();
    }
    
}
class Number{
    var $num;
    function dump(){
        return " n(" .$this->num . " ) ";
    }
}

class Parser{
    var $result;
    var $tokenizer;
    var $currentToken ;
    function __construct(){
    }
    public function parse($s){
        $this->tokenizer = new CFW_Common_Tokenizer(new CFW_IO_StringReader( $s ));
        $this->currentToken = $this->tokenizer->nextToken();
        $this->result = $this->expression();
        
    }
    
    function expression() {
        $result = new Expression();
        $result->terms[] = $this->term(); //最初のterm
        
      while ($this->currentToken == '+') {
            $this->currentToken = $this->tokenizer->nextToken();
              
            $r_ = $this->term();
            $result->terms[] = $r_;
      }
      return $result;
    }
    
    function term() {
        $result = new Term();
        $result->facts[] = $this->fact(); //最初のterm
        while ($this->currentToken == '*') {
            $this->currentToken = $this->tokenizer->nextToken();

            $r_ = $this->fact();
            $result->facts[] = $r_;
            
        }
        return $result;
    }
    function fact() {
        if ($this->currentToken  == '(') {
            $this->currentToken = $this->tokenizer->nextToken();
            $r = $this->expression();
            $this->currentToken = $this->tokenizer->nextToken(); //skip last ")"
            return $r;
        }
        else{
            $value = 0;
            $n = intval($this->currentToken);
            $result = new Number();
            $result->num = $n;
            $this->currentToken = $this->tokenizer->nextToken(); //skip last ")"
            
            return $result;
        }
    }
    
}

$parser = new Parser();
$parser->parse("1 + 2 * 3 + 4 * 5 + 5 + 6 + 7");
echo "-----<br />";
echo "result = " . $parser->result->dump(). "<br />";
echo "-----<br />";
$parser->parse("2 * (3 + 4) + 11"); // = 25
echo "result = " . $parser->result->dump(). "<br />";
echo "-----<br />";
$parser->parse("2 * ((3 + 4) * 5) + 11"); // = 25
echo "result = " . $parser->result->dump(). "<br />";

echo "-----<br />";
$parser->parse("2 * 3 + 4 * 5"); // = 25
echo "result = " . $parser->result->dump(). "<br />";

?>