﻿<?php 
Zend_Loader::loadClass("CFW_Data_TableRow");
Zend_Loader::loadClass("CFW_Data_TableProperty");

/**
* table MAST_MENU Field定義
*/
class CFW_Sample_Model_Base_MastMenuTableRow extends CFW_Data_TableRow
{
    /** 
    * @var String siteCode [SITE_CODE]
    */
    public $siteCode;
    /** 
    * @var String menuCode [MENU_CODE]
    */
    public $menuCode;
    /** 
    * @var Number sortSeq [SORT_SEQ]
    */
    public $sortSeq;
    /** 
    * @var String openDate [OPEN_DATE]
    */
    public $openDate;
    /** 
    * @var String closeDate [CLOSE_DATE]
    */
    public $closeDate;
    /** 
    * @var Number menuGroupCode [MENU_GROUP_CODE]
    */
    public $menuGroupCode;
    /** 
    * @var String name [NAME]
    */
    public $name;
    /** 
    * @var String ankName [ANK_NAME]
    */
    public $ankName;
    /** 
    * @var Number deviceCode [DEVICE_CODE]
    */
    public $deviceCode;
    /** 
    * @var Number menuDeviceCode [MENU_DEVICE_CODE]
    */
    public $menuDeviceCode;
    /** 
    * @var Number menuAdtypeCode [MENU_ADTYPE_CODE]
    */
    public $menuAdtypeCode;
    /** 
    * @var Number optinType [OPTIN_TYPE]
    */
    public $optinType;
    /** 
    * @var Number managementCode [MANAGEMENT_CODE]
    */
    public $managementCode;
    /** 
    * @var Number guaranteeCode [GUARANTEE_CODE]
    */
    public $guaranteeCode;
    /** 
    * @var Number menuCategory1 [MENU_CATEGORY1]
    */
    public $menuCategory1;
    /** 
    * @var Number menuCategory2 [MENU_CATEGORY2]
    */
    public $menuCategory2;
    /** 
    * @var Number listCode [LIST_CODE]
    */
    public $listCode;
    /** 
    * @var Number flameCount [FLAME_COUNT]
    */
    public $flameCount;
    /** 
    * @var Number flameCountKind [FLAME_COUNT_KIND]
    */
    public $flameCountKind;
    /** 
    * @var Number rotationFlameCount [ROTATION_FLAME_COUNT]
    */
    public $rotationFlameCount;
    /** 
    * @var Number flameSelectFlag [FLAME_SELECT_FLAG]
    */
    public $flameSelectFlag;
    /** 
    * @var Number goodsCategoryCode [GOODS_CATEGORY_CODE]
    */
    public $goodsCategoryCode;
    /** 
    * @var String paymentCompany [PAYMENT_COMPANY]
    */
    public $paymentCompany;
    /** 
    * @var Number spOpenFlag [SP_OPEN_FLAG]
    */
    public $spOpenFlag;
    /** 
    * @var Number pmOpenFlag [PM_OPEN_FLAG]
    */
    public $pmOpenFlag;
    /** 
    * @var Number adGuideOpenFlag [AD_GUIDE_OPEN_FLAG]
    */
    public $adGuideOpenFlag;
    /** 
    * @var Number regulationGuideFlag [REGULATION_GUIDE_FLAG]
    */
    public $regulationGuideFlag;
    /** 
    * @var Number ioOpenFlag [IO_OPEN_FLAG]
    */
    public $ioOpenFlag;
    /** 
    * @var Number esAudienceFlag [ES_AUDIENCE_FLAG]
    */
    public $esAudienceFlag;
    /** 
    * @var Number esPerformanceFlag [ES_PERFORMANCE_FLAG]
    */
    public $esPerformanceFlag;
    /** 
    * @var Number esReachFlag [ES_REACH_FLAG]
    */
    public $esReachFlag;
    /** 
    * @var Number searchUrlFlag [SEARCH_URL_FLAG]
    */
    public $searchUrlFlag;
    /** 
    * @var Number packageFlag [PACKAGE_FLAG]
    */
    public $packageFlag;
    /** 
    * @var Number menuSelectionCount [MENU_SELECTION_COUNT]
    */
    public $menuSelectionCount;
    /** 
    * @var Number carrierCode1 [CARRIER_CODE1]
    */
    public $carrierCode1;
    /** 
    * @var Number carrierCode2 [CARRIER_CODE2]
    */
    public $carrierCode2;
    /** 
    * @var Number carrierCode3 [CARRIER_CODE3]
    */
    public $carrierCode3;
    /** 
    * @var Number carrierCode4 [CARRIER_CODE4]
    */
    public $carrierCode4;
    /** 
    * @var String pageRemarks [PAGE_REMARKS]
    */
    public $pageRemarks;
    /** 
    * @var String remarks [REMARKS]
    */
    public $remarks;
    /** 
    * @var String dacRemarks [DAC_REMARKS]
    */
    public $dacRemarks;
    /** 
    * @var String BStatus [B_STATUS]
    */
    public $BStatus;
    /** 
    * @var String DStatus [D_STATUS]
    */
    public $DStatus;
    /** 
    * @var String PStatus [P_STATUS]
    */
    public $PStatus;
    /** 
    * @var String PCampaignStatusFrom [P_CAMPAIGN_STATUS_FROM]
    */
    public $PCampaignStatusFrom;
    /** 
    * @var String PCampaignStatusTo [P_CAMPAIGN_STATUS_TO]
    */
    public $PCampaignStatusTo;
    /** 
    * @var String MStatus [M_STATUS]
    */
    public $MStatus;
    /** 
    * @var String TStatus [T_STATUS]
    */
    public $TStatus;
    /** 
    * @var String totalStatus [TOTAL_STATUS]
    */
    public $totalStatus;
    /** 
    * @var String totalStatusTo [TOTAL_STATUS_TO]
    */
    public $totalStatusTo;
    /** 
    * @var Number countUrlKind [COUNT_URL_KIND]
    */
    public $countUrlKind;
    /** 
    * @var String countUrl [COUNT_URL]
    */
    public $countUrl;
    /** 
    * @var Number reportKind [REPORT_KIND]
    */
    public $reportKind;
    /** 
    * @var String reportDetail [REPORT_DETAIL]
    */
    public $reportDetail;
    /** 
    * @var String reportReceive [REPORT_RECEIVE]
    */
    public $reportReceive;
    /** 
    * @var Number segmentEqualFlag [SEGMENT_EQUAL_FLAG]
    */
    public $segmentEqualFlag;
    /** 
    * @var Number stockFlag [STOCK_FLAG]
    */
    public $stockFlag;
    /** 
    * @var Number stockCount [STOCK_COUNT]
    */
    public $stockCount;
    /** 
    * @var String captureSeq [CAPTURE_SEQ]
    */
    public $captureSeq;
    /** 
    * @var String agCompanyCode [AG_COMPANY_CODE]
    */
    public $agCompanyCode;
    /** 
    * @var Number insideOpenLevel [INSIDE_OPEN_LEVEL]
    */
    public $insideOpenLevel;
    /** 
    * @var Number outsideOpenLevel [OUTSIDE_OPEN_LEVEL]
    */
    public $outsideOpenLevel;
    /** 
    * @var String limitOpenRemarks [LIMIT_OPEN_REMARKS]
    */
    public $limitOpenRemarks;
    /** 
    * @var Number publishPageFlag [PUBLISH_PAGE_FLAG]
    */
    public $publishPageFlag;
    /** 
    * @var String esRemarks [ES_REMARKS]
    */
    public $esRemarks;
    /** 
    * @var String menuFrameCode [MENU_FRAME_CODE]
    */
    public $menuFrameCode;
    /** 
    * @var Number frameNameRefrectFlag [FRAME_NAME_REFRECT_FLAG]
    */
    public $frameNameRefrectFlag;
    /** 
    * @var String deliveryOptionName [DELIVERY_OPTION_NAME]
    */
    public $deliveryOptionName;
    /** 
    * @var String getReportDestination [GET_REPORT_DESTINATION]
    */
    public $getReportDestination;
    /** 
    * @var Number reportTreatKindSeq [REPORT_TREAT_KIND_SEQ]
    */
    public $reportTreatKindSeq;
    /** 
    * @var Number useSiteLimitOpenFlag [USE_SITE_LIMIT_OPEN_FLAG]
    */
    public $useSiteLimitOpenFlag;
    /** 
    * @var Number useSiteCarrierFlag [USE_SITE_CARRIER_FLAG]
    */
    public $useSiteCarrierFlag;
    /** 
    * @var Number costMenuFlag [COST_MENU_FLAG]
    */
    public $costMenuFlag;
    /** 
    * @var String checkName [CHECK_NAME]
    */
    public $checkName;
    /** 
    * @var String priceGroupFromDate [PRICE_GROUP_FROM_DATE]
    */
    public $priceGroupFromDate;
    /** 
    * @var String manuscriptFromDate [MANUSCRIPT_FROM_DATE]
    */
    public $manuscriptFromDate;
    /** 
    * @var String priceCostFromDate [PRICE_COST_FROM_DATE]
    */
    public $priceCostFromDate;
    /** 
    * @var String transmitFromDate [TRANSMIT_FROM_DATE]
    */
    public $transmitFromDate;
    /** 
    * @var Number referSitePriceCostFlag [REFER_SITE_PRICE_COST_FLAG]
    */
    public $referSitePriceCostFlag;
    /** 
    * @var Number teamCode [TEAM_CODE]
    */
    public $teamCode;
    /** 
    * @var Number validFlag [VALID_FLAG]
    */
    public $validFlag;
    /** 
    * @var Date baseUpdateDateTime [BASE_UPDATE_DATE_TIME]
    */
    public $baseUpdateDateTime;
    /** 
    * @var Date insertDateTime [INSERT_DATE_TIME]
    */
    public $insertDateTime;
    /** 
    * @var String insertOperatorCode [INSERT_OPERATOR_CODE]
    */
    public $insertOperatorCode;
    /** 
    * @var Date updateDateTime [UPDATE_DATE_TIME]
    */
    public $updateDateTime;
    /** 
    * @var String operatorCode [OPERATOR_CODE]
    */
    public $operatorCode;
    
    /**
    * default construct 
    */
    public function __construct()
    {
    	parent::__construct();
        $this->siteCode = "";
        $this->menuCode = "";
        $this->sortSeq = null;
        $this->openDate = "";
        $this->closeDate = "";
        $this->menuGroupCode = null;
        $this->name = "";
        $this->ankName = "";
        $this->deviceCode = 0;
        $this->menuDeviceCode = null;
        $this->menuAdtypeCode = null;
        $this->optinType = null;
        $this->managementCode = 0;
        $this->guaranteeCode = 0;
        $this->menuCategory1 = null;
        $this->menuCategory2 = null;
        $this->listCode = null;
        $this->flameCount = null;
        $this->flameCountKind = 0;
        $this->rotationFlameCount = null;
        $this->flameSelectFlag = null;
        $this->goodsCategoryCode = null;
        $this->paymentCompany = "";
        $this->spOpenFlag = null;
        $this->pmOpenFlag = null;
        $this->adGuideOpenFlag = null;
        $this->regulationGuideFlag = null;
        $this->ioOpenFlag = null;
        $this->esAudienceFlag = null;
        $this->esPerformanceFlag = null;
        $this->esReachFlag = null;
        $this->searchUrlFlag = null;
        $this->packageFlag = null;
        $this->menuSelectionCount = null;
        $this->carrierCode1 = null;
        $this->carrierCode2 = null;
        $this->carrierCode3 = null;
        $this->carrierCode4 = null;
        $this->pageRemarks = "";
        $this->remarks = "";
        $this->dacRemarks = "";
        $this->BStatus = "";
        $this->DStatus = "";
        $this->PStatus = "";
        $this->PCampaignStatusFrom = "";
        $this->PCampaignStatusTo = "";
        $this->MStatus = "";
        $this->TStatus = "";
        $this->totalStatus = "";
        $this->totalStatusTo = "";
        $this->countUrlKind = null;
        $this->countUrl = "";
        $this->reportKind = 0;
        $this->reportDetail = "";
        $this->reportReceive = "";
        $this->segmentEqualFlag = null;
        $this->stockFlag = null;
        $this->stockCount = null;
        $this->captureSeq = "";
        $this->agCompanyCode = "";
        $this->insideOpenLevel = null;
        $this->outsideOpenLevel = null;
        $this->limitOpenRemarks = "";
        $this->publishPageFlag = null;
        $this->esRemarks = "";
        $this->menuFrameCode = "";
        $this->frameNameRefrectFlag = null;
        $this->deliveryOptionName = "";
        $this->getReportDestination = "";
        $this->reportTreatKindSeq = null;
        $this->useSiteLimitOpenFlag = null;
        $this->useSiteCarrierFlag = null;
        $this->costMenuFlag = null;
        $this->checkName = "";
        $this->priceGroupFromDate = "";
        $this->manuscriptFromDate = "";
        $this->priceCostFromDate = "";
        $this->transmitFromDate = "";
        $this->referSitePriceCostFlag = null;
        $this->teamCode = null;
        $this->validFlag = null;
        $this->baseUpdateDateTime = null;
        $this->insertDateTime = null;
        $this->insertOperatorCode = "";
        $this->updateDateTime = null;
        $this->operatorCode = "";
        
    }
    
    /**
    * 列名を指定して値を設定
    *
    * @param string name 列名
    * @param object value 値
    */
    public function setValue($name,$value)
    {
        if($name ==  "SITE_CODE") $this->siteCode = CFW_Util_String::stringValue( $value );
        if($name ==  "MENU_CODE") $this->menuCode = CFW_Util_String::stringValue( $value );
        if($name ==  "SORT_SEQ") $this->sortSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "OPEN_DATE") $this->openDate = CFW_Util_String::stringValue( $value );
        if($name ==  "CLOSE_DATE") $this->closeDate = CFW_Util_String::stringValue( $value );
        if($name ==  "MENU_GROUP_CODE") $this->menuGroupCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "NAME") $this->name = CFW_Util_String::stringValue( $value );
        if($name ==  "ANK_NAME") $this->ankName = CFW_Util_String::stringValue( $value );
        if($name ==  "DEVICE_CODE") $this->deviceCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "MENU_DEVICE_CODE") $this->menuDeviceCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "MENU_ADTYPE_CODE") $this->menuAdtypeCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "OPTIN_TYPE") $this->optinType = CFW_Util_Number::numberValue( $value );
        if($name ==  "MANAGEMENT_CODE") $this->managementCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "GUARANTEE_CODE") $this->guaranteeCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "MENU_CATEGORY1") $this->menuCategory1 = CFW_Util_Number::numberValue( $value );
        if($name ==  "MENU_CATEGORY2") $this->menuCategory2 = CFW_Util_Number::numberValue( $value );
        if($name ==  "LIST_CODE") $this->listCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "FLAME_COUNT") $this->flameCount = CFW_Util_Number::numberValue( $value );
        if($name ==  "FLAME_COUNT_KIND") $this->flameCountKind = CFW_Util_Number::numberValue( $value );
        if($name ==  "ROTATION_FLAME_COUNT") $this->rotationFlameCount = CFW_Util_Number::numberValue( $value );
        if($name ==  "FLAME_SELECT_FLAG") $this->flameSelectFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "GOODS_CATEGORY_CODE") $this->goodsCategoryCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "PAYMENT_COMPANY") $this->paymentCompany = CFW_Util_String::stringValue( $value );
        if($name ==  "SP_OPEN_FLAG") $this->spOpenFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "PM_OPEN_FLAG") $this->pmOpenFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "AD_GUIDE_OPEN_FLAG") $this->adGuideOpenFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "REGULATION_GUIDE_FLAG") $this->regulationGuideFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "IO_OPEN_FLAG") $this->ioOpenFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "ES_AUDIENCE_FLAG") $this->esAudienceFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "ES_PERFORMANCE_FLAG") $this->esPerformanceFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "ES_REACH_FLAG") $this->esReachFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "SEARCH_URL_FLAG") $this->searchUrlFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "PACKAGE_FLAG") $this->packageFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "MENU_SELECTION_COUNT") $this->menuSelectionCount = CFW_Util_Number::numberValue( $value );
        if($name ==  "CARRIER_CODE1") $this->carrierCode1 = CFW_Util_Number::numberValue( $value );
        if($name ==  "CARRIER_CODE2") $this->carrierCode2 = CFW_Util_Number::numberValue( $value );
        if($name ==  "CARRIER_CODE3") $this->carrierCode3 = CFW_Util_Number::numberValue( $value );
        if($name ==  "CARRIER_CODE4") $this->carrierCode4 = CFW_Util_Number::numberValue( $value );
        if($name ==  "PAGE_REMARKS") $this->pageRemarks = CFW_Util_String::stringValue( $value );
        if($name ==  "REMARKS") $this->remarks = CFW_Util_String::stringValue( $value );
        if($name ==  "DAC_REMARKS") $this->dacRemarks = CFW_Util_String::stringValue( $value );
        if($name ==  "B_STATUS") $this->BStatus = CFW_Util_String::stringValue( $value );
        if($name ==  "D_STATUS") $this->DStatus = CFW_Util_String::stringValue( $value );
        if($name ==  "P_STATUS") $this->PStatus = CFW_Util_String::stringValue( $value );
        if($name ==  "P_CAMPAIGN_STATUS_FROM") $this->PCampaignStatusFrom = CFW_Util_String::stringValue( $value );
        if($name ==  "P_CAMPAIGN_STATUS_TO") $this->PCampaignStatusTo = CFW_Util_String::stringValue( $value );
        if($name ==  "M_STATUS") $this->MStatus = CFW_Util_String::stringValue( $value );
        if($name ==  "T_STATUS") $this->TStatus = CFW_Util_String::stringValue( $value );
        if($name ==  "TOTAL_STATUS") $this->totalStatus = CFW_Util_String::stringValue( $value );
        if($name ==  "TOTAL_STATUS_TO") $this->totalStatusTo = CFW_Util_String::stringValue( $value );
        if($name ==  "COUNT_URL_KIND") $this->countUrlKind = CFW_Util_Number::numberValue( $value );
        if($name ==  "COUNT_URL") $this->countUrl = CFW_Util_String::stringValue( $value );
        if($name ==  "REPORT_KIND") $this->reportKind = CFW_Util_Number::numberValue( $value );
        if($name ==  "REPORT_DETAIL") $this->reportDetail = CFW_Util_String::stringValue( $value );
        if($name ==  "REPORT_RECEIVE") $this->reportReceive = CFW_Util_String::stringValue( $value );
        if($name ==  "SEGMENT_EQUAL_FLAG") $this->segmentEqualFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "STOCK_FLAG") $this->stockFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "STOCK_COUNT") $this->stockCount = CFW_Util_Number::numberValue( $value );
        if($name ==  "CAPTURE_SEQ") $this->captureSeq = CFW_Util_String::stringValue( $value );
        if($name ==  "AG_COMPANY_CODE") $this->agCompanyCode = CFW_Util_String::stringValue( $value );
        if($name ==  "INSIDE_OPEN_LEVEL") $this->insideOpenLevel = CFW_Util_Number::numberValue( $value );
        if($name ==  "OUTSIDE_OPEN_LEVEL") $this->outsideOpenLevel = CFW_Util_Number::numberValue( $value );
        if($name ==  "LIMIT_OPEN_REMARKS") $this->limitOpenRemarks = CFW_Util_String::stringValue( $value );
        if($name ==  "PUBLISH_PAGE_FLAG") $this->publishPageFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "ES_REMARKS") $this->esRemarks = CFW_Util_String::stringValue( $value );
        if($name ==  "MENU_FRAME_CODE") $this->menuFrameCode = CFW_Util_String::stringValue( $value );
        if($name ==  "FRAME_NAME_REFRECT_FLAG") $this->frameNameRefrectFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "DELIVERY_OPTION_NAME") $this->deliveryOptionName = CFW_Util_String::stringValue( $value );
        if($name ==  "GET_REPORT_DESTINATION") $this->getReportDestination = CFW_Util_String::stringValue( $value );
        if($name ==  "REPORT_TREAT_KIND_SEQ") $this->reportTreatKindSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "USE_SITE_LIMIT_OPEN_FLAG") $this->useSiteLimitOpenFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "USE_SITE_CARRIER_FLAG") $this->useSiteCarrierFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "COST_MENU_FLAG") $this->costMenuFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "CHECK_NAME") $this->checkName = CFW_Util_String::stringValue( $value );
        if($name ==  "PRICE_GROUP_FROM_DATE") $this->priceGroupFromDate = CFW_Util_String::stringValue( $value );
        if($name ==  "MANUSCRIPT_FROM_DATE") $this->manuscriptFromDate = CFW_Util_String::stringValue( $value );
        if($name ==  "PRICE_COST_FROM_DATE") $this->priceCostFromDate = CFW_Util_String::stringValue( $value );
        if($name ==  "TRANSMIT_FROM_DATE") $this->transmitFromDate = CFW_Util_String::stringValue( $value );
        if($name ==  "REFER_SITE_PRICE_COST_FLAG") $this->referSitePriceCostFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "TEAM_CODE") $this->teamCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "VALID_FLAG") $this->validFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "BASE_UPDATE_DATE_TIME") $this->baseUpdateDateTime = CFW_Util_Date::dateValue( $value );
        if($name ==  "INSERT_DATE_TIME") $this->insertDateTime = CFW_Util_Date::dateValue( $value );
        if($name ==  "INSERT_OPERATOR_CODE") $this->insertOperatorCode = CFW_Util_String::stringValue( $value );
        if($name ==  "UPDATE_DATE_TIME") $this->updateDateTime = CFW_Util_Date::dateValue( $value );
        if($name ==  "OPERATOR_CODE") $this->operatorCode = CFW_Util_String::stringValue( $value );
        
    }
    /// <summary>
    /// 列名を指定して値を取得
    /// </summary>
    /// <param name="name">列名</param>
    /**
    * 列名を指定して値を取得
    *
    * @param string name 列名
    * @return object 値
    */
    public function getValue($name)
    {
        if($name ==  "SITE_CODE") return $this->siteCode;
        if($name ==  "MENU_CODE") return $this->menuCode;
        if($name ==  "SORT_SEQ") return $this->sortSeq;
        if($name ==  "OPEN_DATE") return $this->openDate;
        if($name ==  "CLOSE_DATE") return $this->closeDate;
        if($name ==  "MENU_GROUP_CODE") return $this->menuGroupCode;
        if($name ==  "NAME") return $this->name;
        if($name ==  "ANK_NAME") return $this->ankName;
        if($name ==  "DEVICE_CODE") return $this->deviceCode;
        if($name ==  "MENU_DEVICE_CODE") return $this->menuDeviceCode;
        if($name ==  "MENU_ADTYPE_CODE") return $this->menuAdtypeCode;
        if($name ==  "OPTIN_TYPE") return $this->optinType;
        if($name ==  "MANAGEMENT_CODE") return $this->managementCode;
        if($name ==  "GUARANTEE_CODE") return $this->guaranteeCode;
        if($name ==  "MENU_CATEGORY1") return $this->menuCategory1;
        if($name ==  "MENU_CATEGORY2") return $this->menuCategory2;
        if($name ==  "LIST_CODE") return $this->listCode;
        if($name ==  "FLAME_COUNT") return $this->flameCount;
        if($name ==  "FLAME_COUNT_KIND") return $this->flameCountKind;
        if($name ==  "ROTATION_FLAME_COUNT") return $this->rotationFlameCount;
        if($name ==  "FLAME_SELECT_FLAG") return $this->flameSelectFlag;
        if($name ==  "GOODS_CATEGORY_CODE") return $this->goodsCategoryCode;
        if($name ==  "PAYMENT_COMPANY") return $this->paymentCompany;
        if($name ==  "SP_OPEN_FLAG") return $this->spOpenFlag;
        if($name ==  "PM_OPEN_FLAG") return $this->pmOpenFlag;
        if($name ==  "AD_GUIDE_OPEN_FLAG") return $this->adGuideOpenFlag;
        if($name ==  "REGULATION_GUIDE_FLAG") return $this->regulationGuideFlag;
        if($name ==  "IO_OPEN_FLAG") return $this->ioOpenFlag;
        if($name ==  "ES_AUDIENCE_FLAG") return $this->esAudienceFlag;
        if($name ==  "ES_PERFORMANCE_FLAG") return $this->esPerformanceFlag;
        if($name ==  "ES_REACH_FLAG") return $this->esReachFlag;
        if($name ==  "SEARCH_URL_FLAG") return $this->searchUrlFlag;
        if($name ==  "PACKAGE_FLAG") return $this->packageFlag;
        if($name ==  "MENU_SELECTION_COUNT") return $this->menuSelectionCount;
        if($name ==  "CARRIER_CODE1") return $this->carrierCode1;
        if($name ==  "CARRIER_CODE2") return $this->carrierCode2;
        if($name ==  "CARRIER_CODE3") return $this->carrierCode3;
        if($name ==  "CARRIER_CODE4") return $this->carrierCode4;
        if($name ==  "PAGE_REMARKS") return $this->pageRemarks;
        if($name ==  "REMARKS") return $this->remarks;
        if($name ==  "DAC_REMARKS") return $this->dacRemarks;
        if($name ==  "B_STATUS") return $this->BStatus;
        if($name ==  "D_STATUS") return $this->DStatus;
        if($name ==  "P_STATUS") return $this->PStatus;
        if($name ==  "P_CAMPAIGN_STATUS_FROM") return $this->PCampaignStatusFrom;
        if($name ==  "P_CAMPAIGN_STATUS_TO") return $this->PCampaignStatusTo;
        if($name ==  "M_STATUS") return $this->MStatus;
        if($name ==  "T_STATUS") return $this->TStatus;
        if($name ==  "TOTAL_STATUS") return $this->totalStatus;
        if($name ==  "TOTAL_STATUS_TO") return $this->totalStatusTo;
        if($name ==  "COUNT_URL_KIND") return $this->countUrlKind;
        if($name ==  "COUNT_URL") return $this->countUrl;
        if($name ==  "REPORT_KIND") return $this->reportKind;
        if($name ==  "REPORT_DETAIL") return $this->reportDetail;
        if($name ==  "REPORT_RECEIVE") return $this->reportReceive;
        if($name ==  "SEGMENT_EQUAL_FLAG") return $this->segmentEqualFlag;
        if($name ==  "STOCK_FLAG") return $this->stockFlag;
        if($name ==  "STOCK_COUNT") return $this->stockCount;
        if($name ==  "CAPTURE_SEQ") return $this->captureSeq;
        if($name ==  "AG_COMPANY_CODE") return $this->agCompanyCode;
        if($name ==  "INSIDE_OPEN_LEVEL") return $this->insideOpenLevel;
        if($name ==  "OUTSIDE_OPEN_LEVEL") return $this->outsideOpenLevel;
        if($name ==  "LIMIT_OPEN_REMARKS") return $this->limitOpenRemarks;
        if($name ==  "PUBLISH_PAGE_FLAG") return $this->publishPageFlag;
        if($name ==  "ES_REMARKS") return $this->esRemarks;
        if($name ==  "MENU_FRAME_CODE") return $this->menuFrameCode;
        if($name ==  "FRAME_NAME_REFRECT_FLAG") return $this->frameNameRefrectFlag;
        if($name ==  "DELIVERY_OPTION_NAME") return $this->deliveryOptionName;
        if($name ==  "GET_REPORT_DESTINATION") return $this->getReportDestination;
        if($name ==  "REPORT_TREAT_KIND_SEQ") return $this->reportTreatKindSeq;
        if($name ==  "USE_SITE_LIMIT_OPEN_FLAG") return $this->useSiteLimitOpenFlag;
        if($name ==  "USE_SITE_CARRIER_FLAG") return $this->useSiteCarrierFlag;
        if($name ==  "COST_MENU_FLAG") return $this->costMenuFlag;
        if($name ==  "CHECK_NAME") return $this->checkName;
        if($name ==  "PRICE_GROUP_FROM_DATE") return $this->priceGroupFromDate;
        if($name ==  "MANUSCRIPT_FROM_DATE") return $this->manuscriptFromDate;
        if($name ==  "PRICE_COST_FROM_DATE") return $this->priceCostFromDate;
        if($name ==  "TRANSMIT_FROM_DATE") return $this->transmitFromDate;
        if($name ==  "REFER_SITE_PRICE_COST_FLAG") return $this->referSitePriceCostFlag;
        if($name ==  "TEAM_CODE") return $this->teamCode;
        if($name ==  "VALID_FLAG") return $this->validFlag;
        if($name ==  "BASE_UPDATE_DATE_TIME") return $this->baseUpdateDateTime;
        if($name ==  "INSERT_DATE_TIME") return $this->insertDateTime;
        if($name ==  "INSERT_OPERATOR_CODE") return $this->insertOperatorCode;
        if($name ==  "UPDATE_DATE_TIME") return $this->updateDateTime;
        if($name ==  "OPERATOR_CODE") return $this->operatorCode;
        
        return null;
    }
    
    /**
    * 指定データからのコピー
    * @param MastMenuTableRow コピー元
    * @return none
    */
    public function copyFrom($source)
    {
        $this->siteCode = $source->siteCode;
        $this->menuCode = $source->menuCode;
        $this->sortSeq = $source->sortSeq;
        $this->openDate = $source->openDate;
        $this->closeDate = $source->closeDate;
        $this->menuGroupCode = $source->menuGroupCode;
        $this->name = $source->name;
        $this->ankName = $source->ankName;
        $this->deviceCode = $source->deviceCode;
        $this->menuDeviceCode = $source->menuDeviceCode;
        $this->menuAdtypeCode = $source->menuAdtypeCode;
        $this->optinType = $source->optinType;
        $this->managementCode = $source->managementCode;
        $this->guaranteeCode = $source->guaranteeCode;
        $this->menuCategory1 = $source->menuCategory1;
        $this->menuCategory2 = $source->menuCategory2;
        $this->listCode = $source->listCode;
        $this->flameCount = $source->flameCount;
        $this->flameCountKind = $source->flameCountKind;
        $this->rotationFlameCount = $source->rotationFlameCount;
        $this->flameSelectFlag = $source->flameSelectFlag;
        $this->goodsCategoryCode = $source->goodsCategoryCode;
        $this->paymentCompany = $source->paymentCompany;
        $this->spOpenFlag = $source->spOpenFlag;
        $this->pmOpenFlag = $source->pmOpenFlag;
        $this->adGuideOpenFlag = $source->adGuideOpenFlag;
        $this->regulationGuideFlag = $source->regulationGuideFlag;
        $this->ioOpenFlag = $source->ioOpenFlag;
        $this->esAudienceFlag = $source->esAudienceFlag;
        $this->esPerformanceFlag = $source->esPerformanceFlag;
        $this->esReachFlag = $source->esReachFlag;
        $this->searchUrlFlag = $source->searchUrlFlag;
        $this->packageFlag = $source->packageFlag;
        $this->menuSelectionCount = $source->menuSelectionCount;
        $this->carrierCode1 = $source->carrierCode1;
        $this->carrierCode2 = $source->carrierCode2;
        $this->carrierCode3 = $source->carrierCode3;
        $this->carrierCode4 = $source->carrierCode4;
        $this->pageRemarks = $source->pageRemarks;
        $this->remarks = $source->remarks;
        $this->dacRemarks = $source->dacRemarks;
        $this->BStatus = $source->BStatus;
        $this->DStatus = $source->DStatus;
        $this->PStatus = $source->PStatus;
        $this->PCampaignStatusFrom = $source->PCampaignStatusFrom;
        $this->PCampaignStatusTo = $source->PCampaignStatusTo;
        $this->MStatus = $source->MStatus;
        $this->TStatus = $source->TStatus;
        $this->totalStatus = $source->totalStatus;
        $this->totalStatusTo = $source->totalStatusTo;
        $this->countUrlKind = $source->countUrlKind;
        $this->countUrl = $source->countUrl;
        $this->reportKind = $source->reportKind;
        $this->reportDetail = $source->reportDetail;
        $this->reportReceive = $source->reportReceive;
        $this->segmentEqualFlag = $source->segmentEqualFlag;
        $this->stockFlag = $source->stockFlag;
        $this->stockCount = $source->stockCount;
        $this->captureSeq = $source->captureSeq;
        $this->agCompanyCode = $source->agCompanyCode;
        $this->insideOpenLevel = $source->insideOpenLevel;
        $this->outsideOpenLevel = $source->outsideOpenLevel;
        $this->limitOpenRemarks = $source->limitOpenRemarks;
        $this->publishPageFlag = $source->publishPageFlag;
        $this->esRemarks = $source->esRemarks;
        $this->menuFrameCode = $source->menuFrameCode;
        $this->frameNameRefrectFlag = $source->frameNameRefrectFlag;
        $this->deliveryOptionName = $source->deliveryOptionName;
        $this->getReportDestination = $source->getReportDestination;
        $this->reportTreatKindSeq = $source->reportTreatKindSeq;
        $this->useSiteLimitOpenFlag = $source->useSiteLimitOpenFlag;
        $this->useSiteCarrierFlag = $source->useSiteCarrierFlag;
        $this->costMenuFlag = $source->costMenuFlag;
        $this->checkName = $source->checkName;
        $this->priceGroupFromDate = $source->priceGroupFromDate;
        $this->manuscriptFromDate = $source->manuscriptFromDate;
        $this->priceCostFromDate = $source->priceCostFromDate;
        $this->transmitFromDate = $source->transmitFromDate;
        $this->referSitePriceCostFlag = $source->referSitePriceCostFlag;
        $this->teamCode = $source->teamCode;
        $this->validFlag = $source->validFlag;
        $this->baseUpdateDateTime = $source->baseUpdateDateTime;
        $this->insertDateTime = $source->insertDateTime;
        $this->insertOperatorCode = $source->insertOperatorCode;
        $this->updateDateTime = $source->updateDateTime;
        $this->operatorCode = $source->operatorCode;
        
    }
}
