<?php
class CFW_Ldap_Criteria_Term extends CFW_Ldap_Criteria_AbstractExpression{
    var $facts;
    var $modifier;
    
    public function __construct(){
        $this->facts = array();
    }
    public function parse(ArrayIterator &$iterator){
        $fact = new CFW_Ldap_Criteria_Factor();
        $this->facts[] = $fact->parse($iterator); //最初のterm
        while (true) {
            if(!$iterator->valid()) break;
            
            $element = $iterator->current();
            if($element instanceof CFW_Ldap_Criteria_OperatorElement){
                if($element->op !== CFW_Ldap_Criteria::CRITERIA_AND){
                    break;
                }
                
                $iterator->next();
                if(!$iterator->valid()) break;
            }
            
            
            $fact = new CFW_Ldap_Criteria_Factor();
            $this->facts[] = $fact->parse($iterator);
            
        }
        return $this;
        
    }
    public function getExpression(){
        if(count($this->facts) == 1){
            if($this->modifier != ""){
                return "(". $this->modifier . "(". $this->facts[0]->getExpression() . "))";
                
            }
            else{
                return $this->facts[0]->getExpression();
            }
            
        }
        else if(count($this->facts) > 1){
            $s = "&";
            foreach($this->facts as $fact){
                $s .=  $fact->getExpression() ;
            }
            if($this->modifier != ""){
                return "(". $this->modifier . "(" .$s . "))";
                
            }
            else{
                return "(" .$s . ")";
            }
            
        }
        
    }
    public function dump(){
        if(count($this->facts) == 1){
            if($this->modifier != ""){
                return "(". $this->modifier . "(". $this->facts[0]->dump() . "))";
                
            }
            else{
                return $this->facts[0]->dump();
            }
            
        }
        else if(count($this->facts) > 1){
            $s = "&";
            foreach($this->facts as $fact){
                $s .=  $fact->dump() ;
            }
            if($this->modifier != ""){
                return "(". $this->modifier . "(" .$s . "))";
                
            }
            else{
                return "(" .$s . ")";
            }
            
        }
    }
}

?>