<?php
Zend_Loader::loadClass("CFW_Html_Util");

/**
 * Table要素簡易作成
 * @author okada
 * @package CFW_Html
 */
class CFW_Html_Table{
    var $id;
    var $styleName;
    var $styles;

    var $columns;
    var $rows;

    /**
     * 構築
     * @param unknown_type $id
     * @param unknown_type $columns
     * @param unknown_type $rows
     * @param unknown_type $styleName
     * @param unknown_type $styles
     * @return unknown_type
     */
    public function __construct($id,$columns,$rows,$styleName = "",$styles = array()){
        $this->id = $id;
        $this->columns = $columns;
        $this->rows = $rows;

        $this->styleName = $styleName;
        $this->styles = $styles;
    }
    /**
     * 列を追加
     * @param unknown_type $headerText
     * @param unknown_type $dataField
     * @param unknown_type $styleName
     * @return unknown_type
     */
    public function addColumn($headerText,$dataField,$styleName = ""){
        $this->columns[] = array("headerText" => $headerText,
                            "dataField" => $dataField,
                            "styleName" => $styleName);

    }
    /**
     * cssスタイルクラス名 設定
     * @param unknown_type $styleName
     * @return unknown_type
     */
    public function setStyleName($styleName){
        $this->styleName = $styleName;
    }
    /**
     * スタイル設定
     * @param unknown_type $propertyName
     * @param unknown_type $value
     * @return unknown_type
     */
    public function setStyle($propertyName,$value){
        $this->styles[$propertyName] = $value;
    }
    /**
     * データ行設定
     * @param unknown_type $rows
     * @return unknown_type
     */
    public function setRows($rows){
        $this->rows = $rows;
    }
    /**
     * 描画
     * @return string
     */
    public function render(){
        $html = "<table id=\"{$this->id}\" ";
        if($this->styleName != ""){
            $html = " class=\"{$this->styleName}\"";
        }
        if( count( $this->styles ) > 0 ){
            $style = "";
            foreach($this->styles as $name => $value){
                $style .= " {$name}:{$value};";
            }
            if($style != ""){
                $html .= " style=\"{$style}\"";
            }
        }
        $html .= ">";

        $html .= $this->renderHeader();
        $html .= $this->renderFooter();
        $html .= $this->renderBody();

        $html .= "</table>";
        return $html;
    }
    /**
     * thead描画
     * @return unknown_type
     */
    protected function renderHeader(){
        $head = "<thead><tr>";
        foreach($this->columns as $column){
            $head .= "<th>";
            $head .= CFW_Html_Util::escape($column["headerText"]);
            $head .= "</th>";
        }
        $head .= "</tr></thead>";
        return $head;
    }
    /**
     * ｔｂｏｄｙ描画
     * @return unknown_type
     */
    protected function renderBody(){
        $body = "<tbody>";
        foreach($this->rows as $row){
            $body .= "<tr>";
            foreach($this->columns as $column){
                $body .= "<td";
                if(isset( $column["styleName"] ) ){
                    if($column["styleName"] != ""){
                        $body .= " class=\"{$column->styleName}\"";
                    }
                }
                $body .= ">";
                if(is_array( $row ) ){
                    $body .= CFW_Html_Util::escape($row[$column["dataField"]]);

                }
                else{
                    $dataField = $column["dataField"];
                    $value = $row->$dataField;
                    if($value instanceof DateTime){
                        $value = $value->format("Y/m/d H:i:s");
                    }
                    else if(method_exists($value,"__toString")){
                        $value = $value->__toString();
                    }
                    else if(method_exists($value,"toString")){
                        $value = $value->toString();
                    }
                    else{
                        $value = strval($value);
                    }
                    $body .= CFW_Html_Util::escape($value);
                }
                $body .= "</td>";
            }

            $body .= "</tr>";
        }
        $body .= "</tbody>";
        return $body;
    }
    /**
     * tfoot描画
     * @return string
     */
    protected function renderFooter(){
        //currently nothing to do;
        return "";
    }
    /**
     * ショートカットメソッド
     * @param unknown_type $id
     * @param unknown_type $columns
     * @param unknown_type $rows
     * @param unknown_type $styleName
     * @param unknown_type $styles
     * @return string
     */
    public static function create($id,$columns,$rows,$styleName = "",$styles = array()){
        $table = new CFW_Html_Table($id,$columns,$rows,$styleName,$styles);
        return $table->render();
    }
}