<?php
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_Data_Connection");
Zend_Loader::loadClass("Zend_Db");

/**
 * 接続生成クラス
 * @author okada
 * @package CFW_Data
 */
class CFW_Data_ConnectionFactory{
	static $configSection;
	/**
	 * 指定名称を持つ接続を取得する
	 * @param array $names
	 * @return CFW_Data_Connection 指定名称の設定を基にしたCFW_Data_Connection
	 */
	public static function getConnection($names = array()){
        self::$configSection = CFW_Config_Configuration::getInstance("connection")->connection;
        if( is_string($names)){
            $names = split("/",$names);
        }
        $config = self::getConfig($names);

        $connection = new CFW_Data_Connection($config);
        return $connection;
	}
	/**
	 * 指定名称の設定を取得する。
	 * 見つからなければdefault(iniファイル上ではconnection.default.*)
	 * @param unknown_type $names
	 * @return unknown_type
	 */
	static function getConfig($names){
		$config = null;
		$nameLength = count($names);

		for($depth = $nameLength;$depth> 0;$depth--){
			$key = self::buildConfigKey($names,$depth);
			$config = self::$configSection->get($key);
			if( $config != null){
				break;
			}
		}
		if($config == null){
			$config =  self::$configSection->default;
		}
		return $config;
	}
	static function buildConfigKey($name,$depth){
		$key = "";
		for($i = 0;$i < $depth;$i++){
			if($i > 0) $key .= "_";
			$key .= $name[$i];
		}
		return $key;
	}
}