<?php
Zend_Loader::loadClass("Zend_Auth_Result");
Zend_Loader::loadClass("Zend_Amf_Auth_Abstract");
Zend_Loader::loadClass("CFW_Config_Configuration");
/**
 * AMF使用アプリケーションのための認証
 * <p>AMFサービスを利用するアプリケーションがアプリケーション起動時に1回だけ利用する。</p>
 * <p>あらかじめ発行したユーザーIDとパスワードをPHPサービスとAMF利用アプリケーションの双方に設定し、アプリケーションの配布時に同時に配布する。アプリケーションのバージョンが変更されるまで、このユーザーIDとパスワードを変更してはならない(と言うより出来ない)</p>
 * <p>AMFサービス利用アプリケーションは起動時に上のユーザー/パスワードを使ってCFW_Amf_AppKey#generate()を呼び出す。以降はgenerate()の戻り値をremoteObjectのユーザー、パスワードとして使用する。</p>
 * <p></p>
 * @author okada
 * @package CFW_Data_Amf
 */
class CFW_Amf_AppAuth extends  Zend_Amf_Auth_Abstract{
    public function __construct(){
        //parent::__construct();
        $this->logger = CFW_Log_LoggerFactory::getLogger("default",__CLASS__);
        $this->logger->debug(__FUNCTION__,"construct");
    }
    /**
     * appkey発行のための認証.
     *
     * <p>とりあえず、ユーザー/パスワードをcore.iniに書いておき認証処理にする。この値は使用する案件ごとに設定する事。</p>
     * @throws Zend_Auth_Adapter_Exception が、認証処理をできなかった場合に発生します
     * @return Zend_Auth_Result
     */
    public function authenticate()
    {
        $this->logger->debug(__FUNCTION__,"start by ".$this->_username);
        $config = CFW_Config_Configuration::getInstance("core");
        $appAuthConfig = $config->amf->appauth;
        //TODO:ユーザー(AMFサービス使用ユーザー名とパスワードの選定)、失敗したらログに書くとか
        if(($this->_username == $appAuthConfig->user) && ($this->_password == $appAuthConfig->password)){
            $result = new Zend_Auth_Result(Zend_Auth_Result::SUCCESS,$this->_username,array());
            return $result;
        }
        $result = new Zend_Auth_Result(Zend_Auth_Result::FAILURE,null,array("使用できません。"));
        return $result;
    }
}