<?php
Zend_Loader::loadClass("CFW_Log_LoggerFactory");
Zend_Loader::loadClass("CFW_Data_ConnectionFactory");
Zend_Loader::loadClass("CFW_Data_DataSource");
Zend_Loader::loadClass("CFW_Util_Dump");
Zend_Loader::loadClass("CFW_Amf_Data_CriteriaParser");
Zend_Loader::loadClass("CFW_Error_HandlerFactory");
/**
 * AMF呼び出し専用のデータソース
 * @remarks 各メソッド内で一回限りの接続を使用し、連携は不可。
 * 連携させる部分はメソッドを別にする
 * @author okada
 * @package CFW_Data_Amf
 */
class CFW_Amf_Data_DataSourceService{
    var $connection;
    var $datasource;
    var $entityProperty;
    var $logger;
    public function __construct(){
    	$this->logger = CFW_Log_LoggerFactory::getLogger("default",__CLASS__);
    }
    /**
     * 接続を開く
     * @param unknown_type $name
     * @return unknown_type
     */
    function open($name){
    	$this->connection = CFW_Data_ConnectionFactory::getConnection(array($name));
    	$this->connection->connect();
    	$this->datasource = new CFW_Data_DataSource(null);
    	$this->datasource->setConnection($this->connection);


    }
    /**
     * 接続を閉じる
     * @return unknown_type
     */
    function close(){
        $this->connection->disconnect();
        $this->datasource = null;
        $this->connection = null;
    }
    /**
     * エンティティ保存
     * @param unknown_type $name 保存先の接続
     * @param unknown_type $table 保存先のテーブル
     * @param unknown_type $data 保存対象データ
     * @param unknown_type $fields 保存対象列
     * @return unknown
     */
    public function saveData($name,$table,$data,$fields = array()){
        $this->logger->info(__FUNCTION__,"start");
        $this->logger->debug(__FUNCTION__,"name=".$name);
        $this->logger->debug(__FUNCTION__,"table=".$table);
        $this->logger->debug(__FUNCTION__,CFW_Util_Dump::dump( $data ));

        $result = null;
        try{
            $this->open($name);
            $this->datasource->tableName = $table;
            $result = $this->datasource->save($data,$fields);
            $this->close();
        }
        catch(Exception $ex){
            if($this->connection != null){
                $this->close();
            }
            throw $ex;
        }
        $this->logger->info(__FUNCTION__,"end");
        return $result;
    }
    /**
     * 挿入
     * @param unknown_type $name データ挿入先の接続
     * @param unknown_type $table データ挿入先のテーブル
     * @param unknown_type $data 挿入データ
     * @param unknown_type $fields 対象列
     * @return unknown_type
     */
    public function insertData($name,$table,$data,$fields = array()){
        $this->logger->info(__FUNCTION__,"start");
        $this->logger->debug(__FUNCTION__,"name=".$name);
        $this->logger->debug(__FUNCTION__,"table=".$table);
        $this->logger->debug(__FUNCTION__,CFW_Util_Dump::dump( $data ));

        $result = new CFW_Amf_Response();
        try{
            $this->open($name);
            $this->datasource->tableName = $table;
            $result = $this->datasource->insert($data,$fields);
            $this->close();
        }
        catch(Exception $ex){
            if($this->connection != null){
                $this->close();
            }
            throw $ex;
        }
        $this->logger->info(__FUNCTION__,"end");
        return $result;
    }
    /**
     * 更新
     * @param unknown_type $name 更新先の接続
     * @param unknown_type $table 更新先のテーブル
     * @param unknown_type $data 更新対象データ
     * @param unknown_type $criteria 対象行選択条件
     * @param unknown_type $fields 対象列
     * @return unknown_type
     */
    public function updateData($name,$table,$data,$criteria,$fields = array()){
        $this->logger->info(__FUNCTION__,"start");
        $this->logger->debug(__FUNCTION__,"name=".$name);
        $this->logger->debug(__FUNCTION__,"table=".$table);
        $this->logger->debug(__FUNCTION__,CFW_Util_Dump::dump( $data ));
        $this->logger->debug(__FUNCTION__,CFW_Util_Dump::dump( $criteria));

        $result = null;
        try{
            $parser = new CFW_Data_Amf_CriteriaParser();
            $c = $parser->parse($criteria);

            $this->open($name);
            $this->datasource->tableName = $table;
            $result = $this->datasource->update($data,$c,$fields);
            $this->close();
        }
        catch(Exception $ex){
            if($this->connection != null){
                $this->close();
            }
            throw $ex;
        }
        $this->logger->info(__FUNCTION__,"end");
        return $result;
    }
    /**
     * 削除
     * @param unknown_type $name 更新先の接続
     * @param unknown_type $table 更新先のテーブル
     * @param unknown_type $criteria 対象行選択条件
     * @param unknown_type $fields 対象列
     * @return unknown_type
     */
    public function deleteData($name,$table,$criteria,$fields = array()){
        $this->logger->info(__FUNCTION__,"start");
        $this->logger->debug(__FUNCTION__,"name=".$name);
        $this->logger->debug(__FUNCTION__,"table=".$table);
        $this->logger->debug(__FUNCTION__,CFW_Util_Dump::dump( $criteria));

        $result = null;
        try{
            $parser = new CFW_Data_Amf_CriteriaParser();
            $c = $parser->parse($criteria);
            $this->open($name);
            $this->datasource->tableName = $table;
            $result = $this->datasource->delete($c,$fields);
            $this->close();
        }
        catch(Exception $ex){
            if($this->connection != null){
                $this->close();
            }
            throw $ex;
        }
        $this->logger->info(__FUNCTION__,"end");
        return $result;
    }
    /**
     * 検索
     * @param unknown_type $name 接続先名称
     * @param unknown_type $table 対象テーブル
     * @param unknown_type $criteria 検索条件
     * @param unknown_type $fields 選択列
     * @return unknown_type
     */
    public function findData($name,$table,$criteria,$fields = array()){
        $this->logger->info(__FUNCTION__,"start");
        $result = null;
        try{
            $parser = new CFW_Amf_Data_CriteriaParser();
            $c = $parser->parse($criteria);
            $this->open($name);
            $this->datasource->tableName = $table;
            $result = $this->datasource->find($c,$fields);
            $this->close();


        }
        catch(Exception $ex){
            if($this->connection != null){
                $this->close();
            }
            throw $ex;
        }
        $this->logger->info(__FUNCTION__,"end");
        return $result;
    }
}