<?php
class CFW_Model_EntityProperty{
    var $schema;
    var $defaultTableName;
    var $tableName;
    var $entityClass;

    var $_fields;
    var $_primaryKeys;
    var $_identity = "";
    public function __construct($schema,$tableName){
        $this->schema = $schema;
        $this->defaultTableName = $tableName;
        $this->tableName = $tableName;
        $this->entityClass = "CFW_Model_Entity";
        $this->_fields = array();
        $this->_primaryKeys = array();
    }
    public function __set($name,$value){
        return $this->_fields[$name] = $value;
    }
    public function __get($name){
        if(array_key_exists($name,$this->_fields)){
            return $this->_fields[$name];
        }
        return null;
    }

    public function getFields(){
        return $this->_fields;
    }
    public function getUpdateFields(){
        $updates = array();
        foreach($this->_fields as $field){
        	if($field->isIdentity) continue;
            if($field->doUpdate) $updates[$field->fieldName] = $field;
        }
        return $updates;
    }
    public function setFields($fields){
        $this->_fields = $fields;
    }
    public function getPrimaryKeys(){
        return $this->_primaryKeys;
    }
    public function setPrimaryKeys($pkeys){
        $this->_primaryKeys = $pkeys;
    }
    public function getName(){
        return $this->tableName;
    }
    public function setName($value){
        $this->talbeName = $value;
        foreach($this->fields as $field){
           $field->tableName = $value;
        }
    }
    public function resetName(){
        $this->setName($this->defaultTableName);
    }
    public function getDefaultName(){
        return $this->defaultTableName;
    }
    public function setDoUpdate($doUpdate = true){
        foreach($this->_fields as $field){
           $field->doUpdate = $doUpdate;
    }

    }
    public function getEntityClass(){
        return $this->entityClass;
    }

}