<?php
Zend_Loader::loadClass("CFW_Util_String");
/**
 * エンティティクラス
 * @author okada
 *
 */
class CFW_Model_Entity{
    var $isNew = false;
    var $isModified = false;
    var $isDeleted = false;

    public function __get($name){
        if(isset($this->$name)) return $this->$name;
        return null;
    }
    public function __set($name,$value){
        $this->$name = $value;
    }
    
    /**
     * key => valueの形式で与えられたオブジェクトを現在のオブジェクトにセットする
     * @param Array  $object
     * @param String $prefix keyに付けられた前置詞
     * @return none
     */
    public function map($object,$prefix){
        foreach($object as $key => $value){
            $fieldName = CFW_Util_String::lowerCamel(preg_replace( "#^".$prefix."__#","",$key));
            $this->__set($fieldName,$value);
        }
    }

}
?>